/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp.serializer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.springframework.integration.ip.tcp.serializer.AbstractByteArraySerializer;
import org.springframework.integration.ip.tcp.serializer.SoftEndOfStreamException;

public class ByteArrayLengthHeaderSerializer
extends AbstractByteArraySerializer {
    public static final int HEADER_SIZE_INT = 4;
    public static final int HEADER_SIZE_UNSIGNED_SHORT = 2;
    public static final int HEADER_SIZE_UNSIGNED_BYTE = 1;
    private static final int MAX_UNSIGNED_SHORT = 65535;
    private static final int MAX_UNSIGNED_BYTE = 255;
    private final int headerSize;
    private int headerAdjust;

    public ByteArrayLengthHeaderSerializer() {
        this(4);
    }

    public ByteArrayLengthHeaderSerializer(int headerSize) {
        if (headerSize != 4 && headerSize != 1 && headerSize != 2) {
            throw new IllegalArgumentException("Illegal header size:" + headerSize);
        }
        this.headerSize = headerSize;
    }

    protected boolean isInclusive() {
        return this.headerAdjust > 0;
    }

    public void setInclusive(boolean inclusive) {
        this.headerAdjust = inclusive ? this.headerSize : 0;
    }

    public ByteArrayLengthHeaderSerializer inclusive() {
        this.setInclusive(true);
        return this;
    }

    public byte[] deserialize(InputStream inputStream) throws IOException {
        int messageLength = this.readHeader(inputStream) - this.headerAdjust;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Message length is " + messageLength));
        }
        byte[] messagePart = null;
        try {
            if (messageLength > this.getMaxMessageSize()) {
                throw new IOException("Message length " + messageLength + " exceeds max message length: " + this.getMaxMessageSize());
            }
            messagePart = new byte[messageLength];
            this.read(inputStream, messagePart, false);
            return messagePart;
        }
        catch (IOException e) {
            this.publishEvent(e, messagePart, -1);
            throw e;
        }
        catch (RuntimeException e) {
            this.publishEvent(e, messagePart, -1);
            throw e;
        }
    }

    public void serialize(byte[] bytes, OutputStream outputStream) throws IOException {
        this.writeHeader(outputStream, bytes.length + this.headerAdjust);
        outputStream.write(bytes);
    }

    protected int read(InputStream inputStream, byte[] buffer, boolean header) throws IOException {
        int len;
        int needed = buffer.length;
        for (int lengthRead = 0; lengthRead < needed; lengthRead += len) {
            len = inputStream.read(buffer, lengthRead, needed - lengthRead);
            if (len < 0 && header && lengthRead == 0) {
                return len;
            }
            if (len >= 0) continue;
            throw new IOException("Stream closed after " + lengthRead + " of " + needed);
        }
        return 0;
    }

    protected void writeHeader(OutputStream outputStream, int length) throws IOException {
        ByteBuffer lengthPart = ByteBuffer.allocate(this.headerSize);
        switch (this.headerSize) {
            case 4: {
                lengthPart.putInt(length);
                break;
            }
            case 1: {
                if (length > 255) {
                    throw new IllegalArgumentException("Length header:" + this.headerSize + " too short to accommodate message length:" + length);
                }
                lengthPart.put((byte)length);
                break;
            }
            case 2: {
                if (length > 65535) {
                    throw new IllegalArgumentException("Length header:" + this.headerSize + " too short to accommodate message length:" + length);
                }
                lengthPart.putShort((short)length);
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad header size:" + this.headerSize);
            }
        }
        outputStream.write(lengthPart.array());
    }

    protected int readHeader(InputStream inputStream) throws IOException {
        byte[] lengthPart = new byte[this.headerSize];
        try {
            int messageLength;
            int status = this.read(inputStream, lengthPart, true);
            if (status < 0) {
                throw new SoftEndOfStreamException("Stream closed between payloads");
            }
            switch (this.headerSize) {
                case 4: {
                    messageLength = ByteBuffer.wrap(lengthPart).getInt();
                    if (messageLength >= 0) break;
                    throw new IllegalArgumentException("Length header:" + messageLength + " is negative");
                }
                case 1: {
                    messageLength = ByteBuffer.wrap(lengthPart).get() & 0xFF;
                    break;
                }
                case 2: {
                    messageLength = ByteBuffer.wrap(lengthPart).getShort() & 0xFFFF;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Bad header size:" + this.headerSize);
                }
            }
            return messageLength;
        }
        catch (SoftEndOfStreamException e) {
            throw e;
        }
        catch (IOException e) {
            this.publishEvent(e, lengthPart, -1);
            throw e;
        }
        catch (RuntimeException e) {
            this.publishEvent(e, lengthPart, -1);
            throw e;
        }
    }
}

