/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.spring.boot.starter;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.servlet.Filter;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.env.Environment;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import org.ssssssss.magicapi.adapter.ColumnMapperAdapter;
import org.ssssssss.magicapi.adapter.DialectAdapter;
import org.ssssssss.magicapi.adapter.Resource;
import org.ssssssss.magicapi.adapter.ResourceAdapter;
import org.ssssssss.magicapi.adapter.resource.DatabaseResource;
import org.ssssssss.magicapi.cache.DefaultSqlCache;
import org.ssssssss.magicapi.cache.SqlCache;
import org.ssssssss.magicapi.config.MagicConfiguration;
import org.ssssssss.magicapi.config.MagicCorsFilter;
import org.ssssssss.magicapi.config.MagicDynamicDataSource;
import org.ssssssss.magicapi.config.MagicFunction;
import org.ssssssss.magicapi.config.MagicFunctionManager;
import org.ssssssss.magicapi.config.MagicModule;
import org.ssssssss.magicapi.config.MagicWebRequestInterceptor;
import org.ssssssss.magicapi.config.MappingHandlerMapping;
import org.ssssssss.magicapi.controller.MagicAPIController;
import org.ssssssss.magicapi.controller.MagicController;
import org.ssssssss.magicapi.controller.MagicDataSourceController;
import org.ssssssss.magicapi.controller.MagicFunctionController;
import org.ssssssss.magicapi.controller.MagicGroupController;
import org.ssssssss.magicapi.controller.MagicWorkbenchController;
import org.ssssssss.magicapi.controller.RequestHandler;
import org.ssssssss.magicapi.dialect.Dialect;
import org.ssssssss.magicapi.exception.MagicAPIException;
import org.ssssssss.magicapi.interceptor.AuthorizationInterceptor;
import org.ssssssss.magicapi.interceptor.DefaultAuthorizationInterceptor;
import org.ssssssss.magicapi.interceptor.RequestInterceptor;
import org.ssssssss.magicapi.interceptor.SQLInterceptor;
import org.ssssssss.magicapi.logging.LoggerManager;
import org.ssssssss.magicapi.modules.AssertModule;
import org.ssssssss.magicapi.modules.EnvModule;
import org.ssssssss.magicapi.modules.RequestModule;
import org.ssssssss.magicapi.modules.ResponseModule;
import org.ssssssss.magicapi.modules.SQLModule;
import org.ssssssss.magicapi.provider.ApiServiceProvider;
import org.ssssssss.magicapi.provider.ColumnMapperProvider;
import org.ssssssss.magicapi.provider.FunctionServiceProvider;
import org.ssssssss.magicapi.provider.GroupServiceProvider;
import org.ssssssss.magicapi.provider.LanguageProvider;
import org.ssssssss.magicapi.provider.MagicAPIService;
import org.ssssssss.magicapi.provider.PageProvider;
import org.ssssssss.magicapi.provider.ResultProvider;
import org.ssssssss.magicapi.provider.impl.DefaultApiServiceProvider;
import org.ssssssss.magicapi.provider.impl.DefaultFunctionServiceProvider;
import org.ssssssss.magicapi.provider.impl.DefaultGroupServiceProvider;
import org.ssssssss.magicapi.provider.impl.DefaultMagicAPIService;
import org.ssssssss.magicapi.provider.impl.DefaultPageProvider;
import org.ssssssss.magicapi.provider.impl.DefaultResultProvider;
import org.ssssssss.magicapi.provider.impl.JSR223LanguageProvider;
import org.ssssssss.magicapi.spring.boot.starter.CacheConfig;
import org.ssssssss.magicapi.spring.boot.starter.MagicAPIProperties;
import org.ssssssss.magicapi.spring.boot.starter.MagicMongoAutoConfiguration;
import org.ssssssss.magicapi.spring.boot.starter.MagicRedisAutoConfiguration;
import org.ssssssss.magicapi.spring.boot.starter.MagicSwaggerConfiguration;
import org.ssssssss.magicapi.spring.boot.starter.PageConfig;
import org.ssssssss.magicapi.spring.boot.starter.ResourceConfig;
import org.ssssssss.magicapi.spring.boot.starter.SecurityConfig;
import org.ssssssss.magicapi.utils.ClassScanner;
import org.ssssssss.magicapi.utils.PathUtils;
import org.ssssssss.script.MagicResourceLoader;
import org.ssssssss.script.MagicScript;
import org.ssssssss.script.MagicScriptEngine;
import org.ssssssss.script.functions.ExtensionMethod;
import org.ssssssss.script.parsing.ast.statement.AsyncCall;
import org.ssssssss.script.reflection.AbstractReflection;
import org.ssssssss.script.reflection.JavaReflection;

@Configuration
@ConditionalOnClass(value={RequestMappingHandlerMapping.class})
@EnableConfigurationProperties(value={MagicAPIProperties.class})
@Import(value={MagicRedisAutoConfiguration.class, MagicMongoAutoConfiguration.class, MagicSwaggerConfiguration.class})
public class MagicAPIAutoConfiguration
implements WebMvcConfigurer {
    private static final Logger logger = LoggerFactory.getLogger(MagicAPIAutoConfiguration.class);
    @Autowired
    private MagicAPIProperties properties;
    @Autowired(required=false)
    private final List<RequestInterceptor> requestInterceptors = Collections.emptyList();
    @Autowired
    private AuthorizationInterceptor authorizationInterceptor;
    @Autowired(required=false)
    private final List<SQLInterceptor> sqlInterceptors = Collections.emptyList();
    @Autowired
    @Lazy
    private RequestMappingHandlerMapping requestMappingHandlerMapping;
    @Autowired
    private ApplicationContext springContext;
    @Autowired(required=false)
    private final List<ExtensionMethod> extensionMethods = Collections.emptyList();
    @Autowired(required=false)
    private final List<HttpMessageConverter<?>> httpMessageConverters = Collections.emptyList();
    @Autowired(required=false)
    private final List<Dialect> dialects = Collections.emptyList();
    @Autowired(required=false)
    List<ColumnMapperProvider> columnMapperProviders = Collections.emptyList();
    @Autowired(required=false)
    List<MagicFunction> magicFunctions = Collections.emptyList();
    @Autowired
    Environment environment;
    @Autowired
    ApiServiceProvider apiServiceProvider;
    @Autowired
    GroupServiceProvider groupServiceProvider;
    @Autowired
    FunctionServiceProvider functionServiceProvider;
    @Autowired
    MappingHandlerMapping mappingHandlerMapping;
    @Autowired
    ResultProvider resultProvider;
    MagicCorsFilter magicCorsFilter = new MagicCorsFilter();
    private String ALL_CLASS_TXT;

    private String redirectIndex(HttpServletRequest request) {
        if (request.getRequestURI().endsWith("/")) {
            return "redirect:./index.html";
        }
        return "redirect:" + this.properties.getWeb() + "/index.html";
    }

    @ResponseBody
    private MagicAPIProperties readConfig() {
        return this.properties;
    }

    @ResponseBody
    private String readClass() {
        if (this.ALL_CLASS_TXT == null) {
            try {
                this.ALL_CLASS_TXT = StringUtils.join((Iterable)ClassScanner.scan(), (String)"\r\n");
            }
            catch (Throwable t) {
                logger.warn("\u626b\u63cfClass\u5931\u8d25", t);
                this.ALL_CLASS_TXT = "";
            }
        }
        return this.ALL_CLASS_TXT;
    }

    @Bean
    @ConditionalOnMissingBean(value={MagicDynamicDataSource.class})
    @ConditionalOnBean(value={DataSource.class})
    public MagicDynamicDataSource magicDynamicDataSource(DataSource dataSource) {
        MagicDynamicDataSource dynamicDataSource = new MagicDynamicDataSource();
        dynamicDataSource.put(dataSource);
        return dynamicDataSource;
    }

    @Bean
    @ConditionalOnMissingBean(value={Resource.class})
    @ConditionalOnProperty(prefix="magic-api", name={"resource.type"}, havingValue="database")
    public Resource magicDatabaseResource(MagicDynamicDataSource magicDynamicDataSource) {
        ResourceConfig resourceConfig = this.properties.getResource();
        MagicDynamicDataSource.DataSourceNode dataSourceNode = magicDynamicDataSource.getDataSource(resourceConfig.getDatasource());
        if (dataSourceNode == null) {
            throw new IllegalArgumentException(String.format("\u627e\u4e0d\u5230\u6570\u636e\u6e90:%s", resourceConfig.getDatasource()));
        }
        return new DatabaseResource(dataSourceNode.getJdbcTemplate(), resourceConfig.getTableName(), resourceConfig.getPrefix(), resourceConfig.isReadonly());
    }

    @Bean
    @ConditionalOnMissingBean(value={Resource.class})
    @ConditionalOnProperty(prefix="magic-api", name={"resource.type"}, havingValue="file", matchIfMissing=true)
    public Resource magicResource() throws IOException {
        ResourceConfig resourceConfig = this.properties.getResource();
        return ResourceAdapter.getResource((String)resourceConfig.getLocation(), (boolean)resourceConfig.isReadonly());
    }

    @Bean
    @ConditionalOnMissingBean(value={AuthorizationInterceptor.class})
    public AuthorizationInterceptor magicAuthorizationInterceptor() {
        SecurityConfig securityConfig = this.properties.getSecurityConfig();
        return new DefaultAuthorizationInterceptor(securityConfig.getUsername(), securityConfig.getPassword());
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        String web = this.properties.getWeb();
        if (web != null) {
            LoggerManager.createMagicAppender();
            registry.addResourceHandler(new String[]{web + "/**"}).addResourceLocations(new String[]{"classpath:/magic-editor/"});
            try {
                this.requestMappingHandlerMapping.registerMapping((Object)RequestMappingInfo.paths((String[])new String[]{web}).build(), (Object)this, MagicAPIAutoConfiguration.class.getDeclaredMethod("redirectIndex", HttpServletRequest.class));
                this.requestMappingHandlerMapping.registerMapping((Object)RequestMappingInfo.paths((String[])new String[]{web + "/config.json"}).build(), (Object)this, MagicAPIAutoConfiguration.class.getDeclaredMethod("readConfig", new Class[0]));
                this.requestMappingHandlerMapping.registerMapping((Object)RequestMappingInfo.paths((String[])new String[]{web + "/classes.txt"}).produces(new String[]{"text/plain"}).build(), (Object)this, MagicAPIAutoConfiguration.class.getDeclaredMethod("readClass", new Class[0]));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)new MagicWebRequestInterceptor(this.properties.isSupportCrossDomain() ? this.magicCorsFilter : null, this.authorizationInterceptor)).addPathPatterns(new String[]{"/**"});
    }

    @Bean
    @ConditionalOnProperty(prefix="magic-api", value={"support-cross-domain"}, havingValue="true", matchIfMissing=true)
    public FilterRegistrationBean<MagicCorsFilter> magicCorsFilterRegistrationBean() {
        FilterRegistrationBean registration = new FilterRegistrationBean((Filter)this.magicCorsFilter, new ServletRegistrationBean[0]);
        registration.addUrlPatterns(new String[]{"/*"});
        registration.setName("Magic Cors Filter");
        registration.setOrder(Integer.MIN_VALUE);
        return registration;
    }

    @Bean
    @ConditionalOnMissingBean(value={PageProvider.class})
    public PageProvider pageProvider() {
        PageConfig pageConfig = this.properties.getPageConfig();
        logger.info("\u672a\u627e\u5230\u5206\u9875\u5b9e\u73b0,\u91c7\u7528\u9ed8\u8ba4\u5206\u9875\u5b9e\u73b0,\u5206\u9875\u914d\u7f6e:(\u9875\u7801={},\u9875\u5927\u5c0f={},\u9ed8\u8ba4\u9996\u9875={},\u9ed8\u8ba4\u9875\u5927\u5c0f={})", new Object[]{pageConfig.getPage(), pageConfig.getSize(), pageConfig.getDefaultPage(), pageConfig.getDefaultSize()});
        return new DefaultPageProvider(pageConfig.getPage(), pageConfig.getSize(), pageConfig.getDefaultPage(), pageConfig.getDefaultSize());
    }

    @Bean
    @ConditionalOnMissingBean(value={ResultProvider.class})
    public ResultProvider resultProvider() {
        return new DefaultResultProvider(this.properties.getResponse());
    }

    @Bean
    @ConditionalOnMissingBean(value={SqlCache.class})
    public SqlCache sqlCache() {
        CacheConfig cacheConfig = this.properties.getCacheConfig();
        logger.info("\u672a\u627e\u5230SQL\u7f13\u5b58\u5b9e\u73b0\uff0c\u91c7\u7528\u9ed8\u8ba4\u7f13\u5b58\u5b9e\u73b0(LRU+TTL)\uff0c\u7f13\u5b58\u914d\u7f6e:(\u5bb9\u91cf={},TTL={})", (Object)cacheConfig.getCapacity(), (Object)cacheConfig.getTtl());
        return new DefaultSqlCache(cacheConfig.getCapacity(), cacheConfig.getTtl());
    }

    @Bean
    public MappingHandlerMapping mappingHandlerMapping() throws NoSuchMethodException {
        String prefix = StringUtils.isNotBlank((CharSequence)this.properties.getPrefix()) ? PathUtils.replaceSlash((String)("/" + this.properties.getPrefix() + "/")) : null;
        return new MappingHandlerMapping(prefix, this.properties.isAllowOverride());
    }

    @Bean
    @ConditionalOnMissingBean(value={FunctionServiceProvider.class})
    public FunctionServiceProvider functionServiceProvider(GroupServiceProvider groupServiceProvider, Resource magicResource) {
        return new DefaultFunctionServiceProvider(groupServiceProvider, magicResource);
    }

    @Bean
    @ConditionalOnMissingBean(value={GroupServiceProvider.class})
    public GroupServiceProvider groupServiceProvider(Resource magicResource) {
        return new DefaultGroupServiceProvider(magicResource);
    }

    @Bean
    @ConditionalOnMissingBean(value={ApiServiceProvider.class})
    public ApiServiceProvider apiServiceProvider(GroupServiceProvider groupServiceProvider, Resource magicResource) {
        return new DefaultApiServiceProvider(groupServiceProvider, magicResource);
    }

    @Bean
    public MagicAPIService magicAPIService(MappingHandlerMapping mappingHandlerMapping, ResultProvider resultProvider) {
        return new DefaultMagicAPIService(mappingHandlerMapping, resultProvider, this.properties.isThrowException());
    }

    private void setupSpringSecurity() {
        Class<?> clazz = null;
        try {
            clazz = Class.forName("org.springframework.security.core.context.SecurityContextHolder");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (clazz != null) {
            try {
                Method method = clazz.getDeclaredMethod("setStrategyName", String.class);
                method.setAccessible(true);
                method.invoke(clazz, "MODE_INHERITABLETHREADLOCAL");
                logger.info("\u81ea\u52a8\u9002\u914d Spring Security \u6210\u529f");
            }
            catch (Exception ignored) {
                logger.info("\u81ea\u52a8\u9002\u914d Spring Security \u5931\u8d25");
            }
        }
    }

    @Bean
    @ConditionalOnBean(value={DataSource.class})
    public SQLModule magicSqlModule(MagicDynamicDataSource dynamicDataSource, ResultProvider resultProvider, PageProvider pageProvider, SqlCache sqlCache) {
        SQLModule sqlModule = new SQLModule(dynamicDataSource);
        sqlModule.setResultProvider(resultProvider);
        sqlModule.setPageProvider(pageProvider);
        sqlModule.setSqlInterceptors(this.sqlInterceptors);
        ColumnMapperAdapter columnMapperAdapter = new ColumnMapperAdapter();
        this.columnMapperProviders.stream().filter(mapperProvider -> !"default".equals(mapperProvider.name())).forEach(arg_0 -> ((ColumnMapperAdapter)columnMapperAdapter).add(arg_0));
        columnMapperAdapter.setDefault(this.properties.getSqlColumnCase());
        sqlModule.setColumnMapperProvider(columnMapperAdapter);
        sqlModule.setColumnMapRowMapper(columnMapperAdapter.getDefaultColumnMapRowMapper());
        sqlModule.setRowMapColumnMapper(columnMapperAdapter.getDefaultRowMapColumnMapper());
        sqlModule.setSqlCache(sqlCache);
        DialectAdapter dialectAdapter = new DialectAdapter();
        this.dialects.forEach(arg_0 -> ((DialectAdapter)dialectAdapter).add(arg_0));
        sqlModule.setDialectAdapter(dialectAdapter);
        return sqlModule;
    }

    private void setupMagicModules(ResultProvider resultProvider, List<MagicModule> magicModules, List<ExtensionMethod> extensionMethods, List<LanguageProvider> languageProviders) {
        MagicResourceLoader.setClassLoader(className -> {
            try {
                return this.springContext.getBean(className);
            }
            catch (Exception e) {
                Class<?> clazz = null;
                try {
                    clazz = Class.forName(className);
                    return this.springContext.getBean(clazz);
                }
                catch (Exception ex) {
                    return clazz;
                }
            }
        });
        MagicResourceLoader.addScriptLanguageLoader(language -> languageProviders.stream().filter(it -> it.support(language)).findFirst().map(languageProvider -> (context, script) -> {
            try {
                return languageProvider.execute(language, script, context);
            }
            catch (Exception e) {
                throw new MagicAPIException(e.getMessage(), (Throwable)e);
            }
        }).orElse(null));
        logger.info("\u6ce8\u518c\u6a21\u5757:{} -> {}", (Object)"log", Logger.class);
        MagicResourceLoader.addModule((String)"log", (Object)LoggerFactory.getLogger(MagicScript.class));
        List<String> importModules = this.properties.getAutoImportModuleList();
        logger.info("\u6ce8\u518c\u6a21\u5757:{} -> {}", (Object)"env", EnvModule.class);
        MagicResourceLoader.addModule((String)"env", (Object)new EnvModule(this.environment));
        logger.info("\u6ce8\u518c\u6a21\u5757:{} -> {}", (Object)"request", RequestModule.class);
        MagicResourceLoader.addModule((String)"request", (Object)new RequestModule());
        logger.info("\u6ce8\u518c\u6a21\u5757:{} -> {}", (Object)"response", ResponseModule.class);
        MagicResourceLoader.addModule((String)"response", (Object)new ResponseModule(resultProvider));
        logger.info("\u6ce8\u518c\u6a21\u5757:{} -> {}", (Object)"assert", AssertModule.class);
        MagicResourceLoader.addModule((String)"assert", (Object)new AssertModule());
        magicModules.forEach(module -> {
            logger.info("\u6ce8\u518c\u6a21\u5757:{} -> {}", (Object)module.getModuleName(), module.getClass());
            MagicResourceLoader.addModule((String)module.getModuleName(), (Object)module);
        });
        MagicResourceLoader.getModuleNames().stream().filter(importModules::contains).forEach(moduleName -> {
            logger.info("\u81ea\u52a8\u5bfc\u5165\u6a21\u5757\uff1a{}", moduleName);
            MagicScriptEngine.addDefaultImport((String)moduleName, (Object)MagicResourceLoader.loadModule((String)moduleName));
        });
        this.properties.getAutoImportPackageList().forEach(importPackage -> {
            logger.info("\u81ea\u52a8\u5bfc\u5305\uff1a{}", importPackage);
            MagicResourceLoader.addPackage((String)importPackage);
        });
        extensionMethods.forEach(extension -> extension.supports().forEach(support -> {
            logger.info("\u6ce8\u518c\u6269\u5c55:{} -> {}", support, extension.getClass());
            AbstractReflection.getInstance().registerMethodExtension(support, extension);
        }));
    }

    @Bean
    public JSR223LanguageProvider jsr223LanguageProvider() {
        return new JSR223LanguageProvider();
    }

    @Bean
    public MagicConfiguration magicConfiguration(List<MagicModule> magicModules, List<LanguageProvider> languageProviders, @Autowired(required=false) MagicDynamicDataSource magicDynamicDataSource, Resource magicResource) {
        logger.info("magic-api\u5de5\u4f5c\u76ee\u5f55:{}", (Object)magicResource);
        this.setupSpringSecurity();
        AsyncCall.setThreadPoolExecutorSize((int)this.properties.getThreadPoolExecutorSize());
        this.setupMagicModules(this.resultProvider, magicModules, this.extensionMethods, languageProviders);
        MagicConfiguration configuration = new MagicConfiguration();
        configuration.setMagicApiService(this.apiServiceProvider);
        configuration.setGroupServiceProvider(this.groupServiceProvider);
        configuration.setMappingHandlerMapping(this.mappingHandlerMapping);
        configuration.setFunctionServiceProvider(this.functionServiceProvider);
        SecurityConfig securityConfig = this.properties.getSecurityConfig();
        configuration.setUsername(securityConfig.getUsername());
        configuration.setPassword(securityConfig.getPassword());
        configuration.setDebugTimeout(this.properties.getDebugConfig().getTimeout());
        configuration.setHttpMessageConverters(Optional.ofNullable(this.httpMessageConverters).orElse(Collections.emptyList()));
        configuration.setResultProvider(this.resultProvider);
        configuration.setThrowException(this.properties.isThrowException());
        configuration.setMagicDynamicDataSource(magicDynamicDataSource);
        configuration.setEditorConfig(this.properties.getEditorConfig());
        configuration.setWorkspace(magicResource);
        configuration.setAuthorizationInterceptor(this.authorizationInterceptor);
        this.magicFunctions.forEach(JavaReflection::registerFunction);
        securityConfig.setUsername(null);
        securityConfig.setPassword(null);
        String base = this.properties.getWeb();
        this.mappingHandlerMapping.setRequestMappingHandlerMapping(this.requestMappingHandlerMapping);
        MagicDataSourceController dataSourceController = new MagicDataSourceController(configuration);
        if (base != null) {
            configuration.setEnableWeb(true);
            ArrayList<MagicController> controllers = new ArrayList<MagicController>(Arrays.asList(new MagicAPIController(configuration), dataSourceController, new MagicWorkbenchController(configuration), new MagicGroupController(configuration), new MagicFunctionController(configuration)));
            controllers.forEach(item -> this.mappingHandlerMapping.registerController(item, base));
        }
        dataSourceController.registerDataSource();
        this.requestInterceptors.forEach(interceptor -> {
            logger.info("\u6ce8\u518c\u8bf7\u6c42\u62e6\u622a\u5668\uff1a{}", interceptor.getClass());
            configuration.addRequestInterceptor(interceptor);
        });
        if (this.properties.isBanner()) {
            configuration.printBanner();
        }
        MagicFunctionManager magicFunctionManager = new MagicFunctionManager(this.groupServiceProvider, this.functionServiceProvider);
        configuration.setMagicFunctionManager(magicFunctionManager);
        magicFunctionManager.registerFunctionLoader();
        magicFunctionManager.registerAllFunction();
        magicFunctionManager.enableRefresh(this.properties.getRefreshInterval());
        this.mappingHandlerMapping.setHandler((Object)new RequestHandler(configuration));
        this.mappingHandlerMapping.setMagicApiService(this.apiServiceProvider);
        this.mappingHandlerMapping.setGroupServiceProvider(this.groupServiceProvider);
        this.mappingHandlerMapping.registerAllMapping();
        int refreshInterval = this.properties.getRefreshInterval();
        this.mappingHandlerMapping.enableRefresh(refreshInterval);
        if (refreshInterval > 0) {
            Executors.newScheduledThreadPool(1).scheduleAtFixedRate(() -> ((MagicDataSourceController)dataSourceController).registerDataSource(), refreshInterval, refreshInterval, TimeUnit.SECONDS);
        }
        return configuration;
    }
}

