/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.spring.boot.starter;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.ssssssss.magicapi.controller.RequestHandler;
import org.ssssssss.magicapi.spring.boot.starter.CacheConfig;
import org.ssssssss.magicapi.spring.boot.starter.DebugConfig;
import org.ssssssss.magicapi.spring.boot.starter.PageConfig;
import org.ssssssss.magicapi.spring.boot.starter.ResourceConfig;
import org.ssssssss.magicapi.spring.boot.starter.SecurityConfig;
import org.ssssssss.magicapi.spring.boot.starter.SwaggerConfig;

@ConfigurationProperties(prefix="magic-api")
public class MagicAPIProperties {
    private String web;
    private String prefix;
    private boolean banner = true;
    private boolean throwException = false;
    private String autoImportModule = "db";
    private String autoImportPackage;
    private int refreshInterval = 0;
    private boolean allowOverride = false;
    private String sqlColumnCase = "default";
    private int threadPoolExecutorSize = 0;
    private String editorConfig;
    private final String version = RequestHandler.class.getPackage().getImplementationVersion();
    private boolean supportCrossDomain = true;
    private String response;
    @NestedConfigurationProperty
    private SecurityConfig securityConfig = new SecurityConfig();
    @NestedConfigurationProperty
    private PageConfig pageConfig = new PageConfig();
    @NestedConfigurationProperty
    private CacheConfig cacheConfig = new CacheConfig();
    @NestedConfigurationProperty
    private DebugConfig debugConfig = new DebugConfig();
    @NestedConfigurationProperty
    private SwaggerConfig swaggerConfig = new SwaggerConfig();
    @NestedConfigurationProperty
    private ResourceConfig resource = new ResourceConfig();

    public String getEditorConfig() {
        return this.editorConfig;
    }

    public void setEditorConfig(String editorConfig) {
        this.editorConfig = editorConfig;
    }

    public String getWeb() {
        if (StringUtils.isBlank((CharSequence)this.web)) {
            return null;
        }
        if (this.web.endsWith("/**")) {
            return this.web.substring(0, this.web.length() - 3);
        }
        if (this.web.endsWith("/*")) {
            return this.web.substring(0, this.web.length() - 2);
        }
        if (this.web.endsWith("/")) {
            return this.web.substring(0, this.web.length() - 1);
        }
        return this.web;
    }

    public void setWeb(String web) {
        this.web = web;
    }

    public String getSqlColumnCase() {
        return this.sqlColumnCase;
    }

    public void setSqlColumnCase(String sqlColumnCase) {
        this.sqlColumnCase = sqlColumnCase;
    }

    public boolean isBanner() {
        return this.banner;
    }

    public void setBanner(boolean banner) {
        this.banner = banner;
    }

    public PageConfig getPageConfig() {
        return this.pageConfig;
    }

    public void setPageConfig(PageConfig pageConfig) {
        this.pageConfig = pageConfig;
    }

    public boolean isThrowException() {
        return this.throwException;
    }

    public void setThrowException(boolean throwException) {
        this.throwException = throwException;
    }

    public CacheConfig getCacheConfig() {
        return this.cacheConfig;
    }

    public void setCacheConfig(CacheConfig cacheConfig) {
        this.cacheConfig = cacheConfig;
    }

    public DebugConfig getDebugConfig() {
        return this.debugConfig;
    }

    public void setDebugConfig(DebugConfig debugConfig) {
        this.debugConfig = debugConfig;
    }

    public SecurityConfig getSecurityConfig() {
        return this.securityConfig;
    }

    public void setSecurityConfig(SecurityConfig securityConfig) {
        this.securityConfig = securityConfig;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public SwaggerConfig getSwaggerConfig() {
        return this.swaggerConfig;
    }

    public void setSwaggerConfig(SwaggerConfig swaggerConfig) {
        this.swaggerConfig = swaggerConfig;
    }

    public String getAutoImportModule() {
        return this.autoImportModule;
    }

    public List<String> getAutoImportModuleList() {
        return Arrays.asList(this.autoImportModule.replaceAll("\\s", "").split(","));
    }

    public void setAutoImportModule(String autoImport) {
        this.autoImportModule = autoImport;
    }

    public int getRefreshInterval() {
        return this.refreshInterval;
    }

    public void setRefreshInterval(int refreshInterval) {
        this.refreshInterval = refreshInterval;
    }

    public boolean isAllowOverride() {
        return this.allowOverride;
    }

    public void setAllowOverride(boolean allowOverride) {
        this.allowOverride = allowOverride;
    }

    public String getAutoImportPackage() {
        return this.autoImportPackage;
    }

    public void setAutoImportPackage(String autoImportPackage) {
        this.autoImportPackage = autoImportPackage;
    }

    public List<String> getAutoImportPackageList() {
        if (this.autoImportPackage == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(this.autoImportPackage.replaceAll("\\s", "").split(","));
    }

    public int getThreadPoolExecutorSize() {
        return this.threadPoolExecutorSize;
    }

    public void setThreadPoolExecutorSize(int threadPoolExecutorSize) {
        this.threadPoolExecutorSize = threadPoolExecutorSize;
    }

    public String getVersion() {
        return this.version;
    }

    public ResourceConfig getResource() {
        return this.resource;
    }

    public void setResource(ResourceConfig resource) {
        this.resource = resource;
    }

    public boolean isSupportCrossDomain() {
        return this.supportCrossDomain;
    }

    public void setSupportCrossDomain(boolean supportCrossDomain) {
        this.supportCrossDomain = supportCrossDomain;
    }

    public String getResponse() {
        return this.response;
    }

    public void setResponse(String response) {
        this.response = response;
    }
}

