/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.spring.boot.starter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.servlet.ServletContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Primary;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import org.ssssssss.magicapi.config.MappingHandlerMapping;
import org.ssssssss.magicapi.provider.GroupServiceProvider;
import org.ssssssss.magicapi.spring.boot.starter.MagicAPIAutoConfiguration;
import org.ssssssss.magicapi.spring.boot.starter.MagicAPIProperties;
import org.ssssssss.magicapi.spring.boot.starter.SwaggerConfig;
import org.ssssssss.magicapi.swagger.SwaggerProvider;
import springfox.documentation.swagger.web.SwaggerResource;
import springfox.documentation.swagger.web.SwaggerResourcesProvider;

@Configuration
@AutoConfigureAfter(value={MagicAPIAutoConfiguration.class})
@EnableConfigurationProperties(value={MagicAPIProperties.class})
@ConditionalOnClass(name={"springfox.documentation.swagger.web.SwaggerResourcesProvider"})
public class MagicSwaggerConfiguration {
    @Autowired
    @Lazy
    private RequestMappingHandlerMapping requestMappingHandlerMapping;
    @Autowired
    private ApplicationContext context;
    private MagicAPIProperties properties;

    public MagicSwaggerConfiguration(MagicAPIProperties properties) {
        this.properties = properties;
    }

    @Bean
    @Primary
    public SwaggerResourcesProvider magicSwaggerResourcesProvider(MappingHandlerMapping handlerMapping, GroupServiceProvider groupServiceProvider, ServletContext servletContext) throws NoSuchMethodException {
        SwaggerConfig config = this.properties.getSwaggerConfig();
        RequestMappingInfo requestMappingInfo = RequestMappingInfo.paths((String[])new String[]{config.getLocation()}).build();
        SwaggerProvider swaggerProvider = new SwaggerProvider();
        swaggerProvider.setGroupServiceProvider(groupServiceProvider);
        swaggerProvider.setMappingHandlerMapping(handlerMapping);
        swaggerProvider.setTitle(config.getTitle());
        swaggerProvider.setDescription(config.getDescription());
        swaggerProvider.setVersion(config.getVersion());
        swaggerProvider.setBasePath(servletContext.getContextPath());
        this.requestMappingHandlerMapping.registerMapping((Object)requestMappingInfo, (Object)swaggerProvider, SwaggerProvider.class.getDeclaredMethod("swaggerJson", new Class[0]));
        return () -> {
            ArrayList<SwaggerResource> resources = new ArrayList<SwaggerResource>();
            Map beans = this.context.getBeansOfType(SwaggerResourcesProvider.class);
            if (beans != null) {
                for (Map.Entry entry : beans.entrySet()) {
                    if ("magicSwaggerResourcesProvider".equalsIgnoreCase((String)entry.getKey())) continue;
                    resources.addAll((Collection)((SwaggerResourcesProvider)entry.getValue()).get());
                }
            }
            resources.add(this.swaggerResource(config.getName(), config.getLocation()));
            return resources;
        };
    }

    private SwaggerResource swaggerResource(String name, String location) {
        SwaggerResource resource = new SwaggerResource();
        resource.setName(name);
        resource.setLocation(location);
        resource.setSwaggerVersion("2.0");
        return resource;
    }
}

