/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.adapter;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ssssssss.magicapi.dialect.ClickhouseDialect;
import org.ssssssss.magicapi.dialect.DB2Dialect;
import org.ssssssss.magicapi.dialect.Dialect;
import org.ssssssss.magicapi.dialect.DmDialect;
import org.ssssssss.magicapi.dialect.MySQLDialect;
import org.ssssssss.magicapi.dialect.OracleDialect;
import org.ssssssss.magicapi.dialect.PostgreSQLDialect;
import org.ssssssss.magicapi.dialect.SQLServer2005Dialect;
import org.ssssssss.magicapi.dialect.SQLServerDialect;

public class DialectAdapter {
    private static final Logger logger = LoggerFactory.getLogger(DialectAdapter.class);
    private final List<Dialect> dialectList = new ArrayList<Dialect>();
    private final Map<String, Dialect> dialectMap = new ConcurrentHashMap<String, Dialect>();

    public DialectAdapter() {
        this.add(new MySQLDialect());
        this.add(new OracleDialect());
        this.add(new PostgreSQLDialect());
        this.add(new ClickhouseDialect());
        this.add(new DB2Dialect());
        this.add(new SQLServerDialect());
        this.add(new SQLServer2005Dialect());
        this.add(new DmDialect());
    }

    public void add(Dialect dialect) {
        this.dialectList.add(dialect);
    }

    public Dialect getDialectFromUrl(String fromUrl) {
        Dialect cached = this.dialectMap.get(fromUrl);
        if (cached == null && !this.dialectMap.containsKey(fromUrl)) {
            for (Dialect dialect : this.dialectList) {
                if (!dialect.match(fromUrl)) continue;
                cached = dialect;
                break;
            }
            if (cached == null) {
                logger.warn(String.format("magic-api\u5728%s\u4e2d\u65e0\u6cd5\u83b7\u53d6dialect", fromUrl));
            }
            this.dialectMap.put(fromUrl, cached);
        }
        return cached;
    }
}

