/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.adapter.resource;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.ssssssss.magicapi.adapter.Resource;
import org.ssssssss.magicapi.adapter.resource.KeyValueResource;
import org.ssssssss.magicapi.utils.IoUtils;

public class DatabaseResource
extends KeyValueResource {
    private final JdbcTemplate template;
    private final String tableName;
    private Map<String, String> cachedContent = new ConcurrentHashMap<String, String>();

    public DatabaseResource(JdbcTemplate template, String tableName) {
        this(template, tableName, false);
    }

    public DatabaseResource(JdbcTemplate template, String tableName, boolean readonly) {
        this(template, tableName, "/magic-api", readonly);
    }

    public DatabaseResource(JdbcTemplate template, String tableName, String path, boolean readonly) {
        this(template, tableName, path, readonly, null);
    }

    public DatabaseResource(JdbcTemplate template, String tableName, String path, boolean readonly, KeyValueResource parent) {
        super("/", path, readonly, parent);
        this.template = template;
        this.tableName = tableName;
    }

    public DatabaseResource(JdbcTemplate template, String tableName, String path, boolean readonly, Map<String, String> cachedContent, KeyValueResource parent) {
        this(template, tableName, path, readonly, parent);
        this.cachedContent = cachedContent;
    }

    @Override
    public byte[] read() {
        String value = this.cachedContent.get(this.path);
        if (value == null) {
            String sql = String.format("select file_content from %s where file_path = ?", this.tableName);
            value = (String)this.template.queryForObject(sql, String.class, new Object[]{this.path});
        }
        return value == null ? new byte[]{} : value.getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public void readAll() {
        this.cachedContent.clear();
        String sql = String.format("select file_path, file_content from %s where file_path like '%s%%'", this.tableName, this.path);
        SqlRowSet sqlRowSet = this.template.queryForRowSet(sql);
        while (sqlRowSet.next()) {
            Object object = sqlRowSet.getObject(2);
            String content = null;
            if (object instanceof String) {
                content = object.toString();
            } else if (object instanceof byte[]) {
                content = new String((byte[])object, StandardCharsets.UTF_8);
            } else if (object instanceof Blob) {
                Blob blob = (Blob)object;
                try (InputStream is = blob.getBinaryStream();){
                    content = new String(IoUtils.bytes(is), StandardCharsets.UTF_8);
                }
                catch (IOException | SQLException exception) {
                    // empty catch block
                }
            }
            this.cachedContent.put(sqlRowSet.getString(1), content);
        }
    }

    @Override
    public boolean exists() {
        if (this.cachedContent.containsKey(this.path)) {
            return true;
        }
        String sql = String.format("select count(*) from %s where file_path = ?", this.tableName);
        Long value = (Long)this.template.queryForObject(sql, Long.class, new Object[]{this.path});
        return value != null && value > 0L;
    }

    @Override
    public boolean write(String content) {
        String sql = String.format("update %s set file_content = ? where file_path = ?", this.tableName);
        if (this.exists() && this.template.update(sql, new Object[]{content, this.path}) > 0) {
            this.cachedContent.put(this.path, content);
            return true;
        }
        sql = String.format("insert into %s (file_path,file_content) values(?,?)", this.tableName);
        if (this.template.update(sql, new Object[]{this.path, content}) > 0) {
            this.cachedContent.put(this.path, content);
            return true;
        }
        return false;
    }

    @Override
    public Set<String> keys() {
        String sql = String.format("select file_path from %s where file_path like '%s%%'", this.tableName, this.isDirectory() ? this.path : this.path + this.separator);
        return new HashSet<String>(this.template.queryForList(sql, String.class));
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean renameTo(Map<String, String> renameKeys) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean delete() {
        String sql = String.format("delete from %s where file_path = ? or file_path like '%s%%'", this.tableName, this.isDirectory() ? this.path : this.path + this.separator);
        if (this.template.update(sql, new Object[]{this.path}) > 0) {
            this.cachedContent.remove(this.path);
            return true;
        }
        return false;
    }

    @Override
    public Function<String, Resource> mappedFunction() {
        return it -> new DatabaseResource(this.template, this.tableName, (String)it, this.readonly, this.cachedContent, this);
    }

    public String toString() {
        return String.format("db://%s/%s", this.tableName, Objects.toString(this.path, ""));
    }

    private /* synthetic */ void lambda$renameTo$70(String oldKey, String newKey) {
        this.cachedContent.put(newKey, this.cachedContent.remove(oldKey));
    }
}

