/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.adapter.resource;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import org.ssssssss.magicapi.adapter.Resource;
import org.ssssssss.magicapi.utils.IoUtils;
import org.ssssssss.magicapi.utils.PathUtils;

public class JarResource
implements Resource {
    private final JarFile jarFile;
    private final ZipEntry entry;
    private final List<JarEntry> entries;
    private final String entryName;
    private JarResource parent = this;
    private final boolean inSpringBoot;

    public JarResource(JarFile jarFile, String entryName, List<JarEntry> entries, boolean inSpringBoot) {
        this.jarFile = jarFile;
        this.entryName = entryName;
        this.inSpringBoot = inSpringBoot;
        this.entry = this.getEntry(this.entryName);
        this.entries = entries;
    }

    public JarResource(JarFile jarFile, String entryName, List<JarEntry> entries, JarResource parent, boolean inSpringBoot) {
        this(jarFile, entryName, entries, inSpringBoot);
        this.parent = parent;
    }

    @Override
    public String separator() {
        return "/";
    }

    @Override
    public boolean readonly() {
        return true;
    }

    @Override
    public byte[] read() {
        try {
            return IoUtils.bytes(this.jarFile.getInputStream(this.entry));
        }
        catch (IOException e) {
            return new byte[0];
        }
    }

    @Override
    public boolean isDirectory() {
        return this.entry.isDirectory();
    }

    @Override
    public boolean exists() {
        return this.entry != null;
    }

    protected ZipEntry getEntry(String name) {
        if (this.inSpringBoot && name.startsWith("BOOT-INF/classes/")) {
            name = name.substring("BOOT-INF/classes/".length());
        }
        return this.jarFile.getEntry(name);
    }

    @Override
    public Resource getResource(String name) {
        String entryName = PathUtils.replaceSlash(this.entryName + "/" + name);
        String prefix = PathUtils.replaceSlash(entryName + "/");
        return new JarResource(this.jarFile, entryName, this.entries.stream().filter(it -> it.getName().startsWith(prefix)).collect(Collectors.toList()), this, this.inSpringBoot);
    }

    @Override
    public String name() {
        int index;
        String name = this.entryName;
        if (this.isDirectory()) {
            name = name.substring(0, name.length() - 1);
        }
        return (index = name.lastIndexOf("/")) > -1 ? name.substring(index + 1) : name;
    }

    @Override
    public Resource parent() {
        return this.parent;
    }

    @Override
    public List<Resource> dirs() {
        return this.resources().stream().filter(Resource::isDirectory).collect(Collectors.toList());
    }

    @Override
    public List<Resource> files(String suffix) {
        return this.entries.stream().filter(it -> it.getName().endsWith(suffix)).map(entry -> new JarResource(this.jarFile, entry.getName(), Collections.emptyList(), this.inSpringBoot)).collect(Collectors.toList());
    }

    @Override
    public List<Resource> resources() {
        String prefix = PathUtils.replaceSlash(this.entryName + "/");
        return this.entries.stream().filter(it -> it.getName().startsWith(prefix)).map(entry -> new JarResource(this.jarFile, entry.getName(), this.entries.stream().filter(item -> item.getName().startsWith(PathUtils.replaceSlash(entry.getName() + "/"))).collect(Collectors.toList()), this.inSpringBoot)).collect(Collectors.toList());
    }

    @Override
    public String getAbsolutePath() {
        return this.jarFile.getName() + "/" + this.entryName;
    }

    public String toString() {
        return String.format("jar://%s", this.entryName);
    }
}

