/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.config;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.ssssssss.magicapi.adapter.DialectAdapter;
import org.ssssssss.magicapi.dialect.Dialect;
import org.ssssssss.magicapi.exception.MagicAPIException;
import org.ssssssss.magicapi.utils.Assert;

public class MagicDynamicDataSource {
    private static final Logger logger = LoggerFactory.getLogger(MagicDynamicDataSource.class);
    private final Map<String, DataSourceNode> dataSourceMap = new HashMap<String, DataSourceNode>();

    public void put(DataSource dataSource) {
        this.put(null, dataSource);
    }

    public void put(String dataSourceKey, DataSource dataSource) {
        this.put(null, dataSourceKey, dataSourceKey, dataSource);
    }

    public void put(String id, String dataSourceKey, String datasourceName, DataSource dataSource) {
        if (dataSourceKey == null) {
            dataSourceKey = "";
        }
        logger.info("\u6ce8\u518c\u6570\u636e\u6e90\uff1a{}", (Object)(StringUtils.isNotBlank((CharSequence)dataSourceKey) ? dataSourceKey : "default"));
        this.dataSourceMap.put(dataSourceKey, new DataSourceNode(dataSource, dataSourceKey, datasourceName, id));
        if (id != null) {
            String finalDataSourceKey = dataSourceKey;
            this.dataSourceMap.entrySet().stream().filter(it -> id.equals(((DataSourceNode)it.getValue()).getId()) && !finalDataSourceKey.equals(((DataSourceNode)it.getValue()).getKey())).findFirst().ifPresent(it -> {
                logger.info("\u79fb\u9664\u65e7\u6570\u636e\u6e90:{}", (Object)((DataSourceNode)it.getValue()).getKey());
                this.dataSourceMap.remove(((DataSourceNode)it.getValue()).getKey());
            });
        }
    }

    public List<String> datasources() {
        return new ArrayList<String>(this.dataSourceMap.keySet());
    }

    public Collection<DataSourceNode> datasourceNodes() {
        return this.dataSourceMap.values();
    }

    public boolean delete(String datasourceKey) {
        boolean result = false;
        if (datasourceKey != null && !datasourceKey.isEmpty()) {
            result = this.dataSourceMap.remove(datasourceKey) != null;
        }
        logger.info("\u5220\u9664\u6570\u636e\u6e90\uff1a{}:{}", (Object)datasourceKey, (Object)(result ? "\u6210\u529f" : "\u5931\u8d25"));
        return result;
    }

    public DataSourceNode getDataSource() {
        return this.getDataSource(null);
    }

    public DataSourceNode getDataSource(String datasourceKey) {
        if (datasourceKey == null) {
            datasourceKey = "";
        }
        DataSourceNode dataSourceNode = this.dataSourceMap.get(datasourceKey);
        Assert.isNotNull(dataSourceNode, String.format("\u627e\u4e0d\u5230\u6570\u636e\u6e90%s", datasourceKey));
        return dataSourceNode;
    }

    public void setDefault(DataSource dataSource) {
        this.put(dataSource);
    }

    public void add(String dataSourceKey, DataSource dataSource) {
        this.put(dataSourceKey, dataSource);
    }

    public static class DataSourceNode {
        private final String id;
        private final String key;
        private final String name;
        private final DataSourceTransactionManager dataSourceTransactionManager;
        private final JdbcTemplate jdbcTemplate;
        private final DataSource dataSource;
        private Dialect dialect;

        DataSourceNode(DataSource dataSource, String key) {
            this(dataSource, key, key, null);
        }

        DataSourceNode(DataSource dataSource, String key, String name, String id) {
            this.dataSource = dataSource;
            this.key = key;
            this.name = name;
            this.id = id;
            this.dataSourceTransactionManager = new DataSourceTransactionManager(this.dataSource);
            this.jdbcTemplate = new JdbcTemplate(dataSource);
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getKey() {
            return this.key;
        }

        public JdbcTemplate getJdbcTemplate() {
            return this.jdbcTemplate;
        }

        public DataSourceTransactionManager getDataSourceTransactionManager() {
            return this.dataSourceTransactionManager;
        }

        public Dialect getDialect(DialectAdapter dialectAdapter) {
            if (this.dialect == null) {
                Connection connection = null;
                try {
                    connection = this.dataSource.getConnection();
                    this.dialect = dialectAdapter.getDialectFromUrl(connection.getMetaData().getURL());
                    if (this.dialect == null) {
                        throw new MagicAPIException("\u81ea\u52a8\u83b7\u53d6\u6570\u636e\u5e93\u65b9\u8a00\u5931\u8d25");
                    }
                }
                catch (Exception e) {
                    throw new MagicAPIException("\u81ea\u52a8\u83b7\u53d6\u6570\u636e\u5e93\u65b9\u8a00\u5931\u8d25", e);
                }
                finally {
                    DataSourceUtils.releaseConnection((Connection)connection, (DataSource)this.dataSource);
                }
            }
            return this.dialect;
        }
    }
}

