/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.controller;

import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.ssssssss.magicapi.config.MagicConfiguration;
import org.ssssssss.magicapi.config.Valid;
import org.ssssssss.magicapi.controller.MagicController;
import org.ssssssss.magicapi.controller.MagicExceptionHandler;
import org.ssssssss.magicapi.interceptor.Authorization;
import org.ssssssss.magicapi.model.ApiInfo;
import org.ssssssss.magicapi.model.JsonBean;
import org.ssssssss.magicapi.provider.ApiServiceProvider;
import org.ssssssss.magicapi.utils.IoUtils;

public class MagicAPIController
extends MagicController
implements MagicExceptionHandler {
    private final ApiServiceProvider magicApiService;

    public MagicAPIController(MagicConfiguration configuration) {
        super(configuration);
        this.magicApiService = configuration.getMagicApiService();
    }

    @RequestMapping(value={"/delete"})
    @ResponseBody
    @Valid(readonly=false, authorization=Authorization.DELETE)
    public JsonBean<Boolean> delete(String id) {
        boolean success = this.magicApiService.delete(id);
        if (success) {
            this.configuration.getMappingHandlerMapping().unregisterMapping(id, true);
        }
        return new JsonBean<Boolean>(success);
    }

    @RequestMapping(value={"/list"})
    @ResponseBody
    @Valid(authorization=Authorization.VIEW)
    public JsonBean<List<ApiInfo>> list() {
        return new JsonBean<List<ApiInfo>>(this.magicApiService.list());
    }

    @RequestMapping(value={"/get"})
    @ResponseBody
    @Valid(authorization=Authorization.VIEW)
    public JsonBean<ApiInfo> get(String id) {
        return new JsonBean<ApiInfo>((ApiInfo)this.magicApiService.get(id));
    }

    @RequestMapping(value={"/backups"})
    @ResponseBody
    @Valid(authorization=Authorization.VIEW)
    public JsonBean<List<Long>> backups(String id) {
        return new JsonBean<List<Long>>(this.magicApiService.backupList(id));
    }

    @RequestMapping(value={"/backup/get"})
    @ResponseBody
    @Valid(authorization=Authorization.VIEW)
    public JsonBean<ApiInfo> backups(String id, Long timestamp) {
        return new JsonBean<ApiInfo>((ApiInfo)this.magicApiService.backupInfo(id, timestamp));
    }

    @RequestMapping(value={"/api/move"})
    @ResponseBody
    @Valid(readonly=false, authorization=Authorization.SAVE)
    public JsonBean<Boolean> apiMove(String id, String groupId) {
        this.isTrue(this.configuration.getGroupServiceProvider().containsApiGroup(groupId), GROUP_NOT_FOUND);
        this.isTrue(this.magicApiService.allowMove(id, groupId), NAME_CONFLICT);
        this.isTrue(this.configuration.getMappingHandlerMapping().move(id, groupId), REQUEST_PATH_CONFLICT);
        return new JsonBean<Boolean>(this.magicApiService.move(id, groupId));
    }

    @RequestMapping(value={"/save"})
    @ResponseBody
    @Valid(readonly=false, authorization=Authorization.SAVE)
    public JsonBean<String> save(@RequestBody ApiInfo info) {
        this.notBlank(info.getMethod(), REQUEST_METHOD_REQUIRED);
        this.notBlank(info.getPath(), REQUEST_PATH_REQUIRED);
        this.notBlank(info.getName(), API_NAME_REQUIRED);
        this.notBlank(info.getScript(), SCRIPT_REQUIRED);
        this.isTrue(IoUtils.validateFileName(info.getName()), NAME_INVALID);
        this.isTrue(!this.configuration.getMappingHandlerMapping().hasRegisterMapping(info), REQUEST_PATH_CONFLICT);
        if (StringUtils.isBlank((CharSequence)info.getId())) {
            this.isTrue(!this.magicApiService.exists(info), API_ALREADY_EXISTS.format(info.getMethod(), info.getPath()));
            this.isTrue(this.magicApiService.insert(info), API_SAVE_FAILURE);
        } else {
            this.isTrue(!this.magicApiService.existsWithoutId(info), API_ALREADY_EXISTS.format(info.getMethod(), info.getPath()));
            Optional<ApiInfo> optional = this.configuration.getMappingHandlerMapping().getApiInfos().stream().filter(it -> it.getId().equals(info.getId())).findFirst();
            if (optional.isPresent() && !optional.get().equals(info)) {
                this.isTrue(this.magicApiService.update(info), API_SAVE_FAILURE);
                this.magicApiService.backup(info);
            }
        }
        this.configuration.getMappingHandlerMapping().registerMapping(info, true);
        return new JsonBean<String>(info.getId());
    }
}

