/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.controller;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.ssssssss.magicapi.config.MagicConfiguration;
import org.ssssssss.magicapi.config.Valid;
import org.ssssssss.magicapi.exception.InvalidArgumentException;
import org.ssssssss.magicapi.exception.MagicLoginException;
import org.ssssssss.magicapi.interceptor.Authorization;
import org.ssssssss.magicapi.interceptor.MagicUser;
import org.ssssssss.magicapi.model.JsonBean;
import org.ssssssss.magicapi.model.JsonCode;
import org.ssssssss.magicapi.model.JsonCodeConstants;

public class MagicController
implements JsonCodeConstants {
    MagicConfiguration configuration;

    MagicController(MagicConfiguration configuration) {
        this.configuration = configuration;
    }

    public void doValid(HttpServletRequest request, Valid valid) {
        if (valid != null) {
            if (!valid.readonly() && this.configuration.getWorkspace().readonly()) {
                throw new InvalidArgumentException(IS_READ_ONLY);
            }
            if (valid.authorization() != Authorization.NONE && !this.allowVisit(request, valid.authorization())) {
                throw new InvalidArgumentException(PERMISSION_INVALID);
            }
        }
    }

    public void notNull(Object value, JsonCode jsonCode) {
        if (value == null) {
            throw new InvalidArgumentException(jsonCode);
        }
    }

    public void isTrue(boolean value, JsonCode jsonCode) {
        if (!value) {
            throw new InvalidArgumentException(jsonCode);
        }
    }

    public void notBlank(String value, JsonCode jsonCode) {
        this.isTrue(StringUtils.isNotBlank((CharSequence)value), jsonCode);
    }

    boolean allowVisit(HttpServletRequest request, Authorization authorization) {
        if (authorization == null) {
            return true;
        }
        MagicUser magicUser = (MagicUser)request.getAttribute("MAGIC_API_ATTRIBUTE_USER");
        return this.configuration.getAuthorizationInterceptor().allowVisit(magicUser, request, authorization);
    }

    @ExceptionHandler(value={MagicLoginException.class})
    @ResponseBody
    public JsonBean<Void> invalidLogin(MagicLoginException exception) {
        return new JsonBean<Void>(-1, exception.getMessage());
    }
}

