/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.controller;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.ssssssss.magicapi.config.MagicConfiguration;
import org.ssssssss.magicapi.config.Valid;
import org.ssssssss.magicapi.controller.MagicController;
import org.ssssssss.magicapi.controller.MagicExceptionHandler;
import org.ssssssss.magicapi.interceptor.Authorization;
import org.ssssssss.magicapi.model.FunctionInfo;
import org.ssssssss.magicapi.model.JsonBean;
import org.ssssssss.magicapi.provider.FunctionServiceProvider;
import org.ssssssss.magicapi.utils.IoUtils;

public class MagicFunctionController
extends MagicController
implements MagicExceptionHandler {
    private final FunctionServiceProvider functionService;

    public MagicFunctionController(MagicConfiguration configuration) {
        super(configuration);
        this.functionService = configuration.getFunctionServiceProvider();
    }

    @RequestMapping(value={"/function/list"})
    @ResponseBody
    @Valid(authorization=Authorization.VIEW)
    public JsonBean<List<FunctionInfo>> list() {
        return new JsonBean<List<FunctionInfo>>(this.functionService.list());
    }

    @RequestMapping(value={"/function/get"})
    @ResponseBody
    @Valid(authorization=Authorization.VIEW)
    public JsonBean<FunctionInfo> get(String id) {
        return new JsonBean<FunctionInfo>((FunctionInfo)this.functionService.get(id));
    }

    @RequestMapping(value={"/function/backup/get"})
    @ResponseBody
    @Valid(authorization=Authorization.VIEW)
    public JsonBean<FunctionInfo> backups(String id, Long timestamp) {
        return new JsonBean<FunctionInfo>((FunctionInfo)this.functionService.backupInfo(id, timestamp));
    }

    @RequestMapping(value={"/function/backups"})
    @ResponseBody
    @Valid(authorization=Authorization.VIEW)
    public JsonBean<List<Long>> backups(String id) {
        return new JsonBean<List<Long>>(this.functionService.backupList(id));
    }

    @RequestMapping(value={"/function/move"})
    @ResponseBody
    @Valid(readonly=false, authorization=Authorization.SAVE)
    public JsonBean<Boolean> move(String id, String groupId) {
        this.isTrue(this.functionService.allowMove(id, groupId), NAME_CONFLICT);
        this.isTrue(this.configuration.getMagicFunctionManager().move(id, groupId), FUNCTION_PATH_CONFLICT);
        return new JsonBean<Boolean>(this.functionService.move(id, groupId));
    }

    @RequestMapping(value={"/function/save"})
    @ResponseBody
    @Valid(readonly=false, authorization=Authorization.SAVE)
    public JsonBean<String> save(@RequestBody FunctionInfo functionInfo) {
        this.notBlank(functionInfo.getName(), FUNCTION_NAME_REQUIRED);
        this.isTrue(IoUtils.validateFileName(functionInfo.getName()), NAME_INVALID);
        this.notBlank(functionInfo.getPath(), FUNCTION_PATH_REQUIRED);
        this.notBlank(functionInfo.getScript(), SCRIPT_REQUIRED);
        this.isTrue(!this.configuration.getMagicFunctionManager().hasRegister(functionInfo), FUNCTION_PATH_CONFLICT);
        if (StringUtils.isBlank((CharSequence)functionInfo.getId())) {
            this.isTrue(!this.functionService.exists(functionInfo), FUNCTION_ALREADY_EXISTS.format(functionInfo.getPath()));
            this.isTrue(this.functionService.insert(functionInfo), FUNCTION_SAVE_FAILURE);
        } else {
            this.isTrue(!this.functionService.existsWithoutId(functionInfo), FUNCTION_ALREADY_EXISTS.format(functionInfo.getPath()));
            this.isTrue(this.functionService.update(functionInfo), FUNCTION_SAVE_FAILURE);
            this.functionService.backup(functionInfo);
        }
        this.configuration.getMagicFunctionManager().register(functionInfo);
        return new JsonBean<String>(functionInfo.getId());
    }

    @RequestMapping(value={"/function/delete"})
    @ResponseBody
    @Valid(readonly=false, authorization=Authorization.DELETE)
    public JsonBean<Boolean> delete(String id) {
        boolean success = this.functionService.delete(id);
        if (success) {
            this.configuration.getMagicFunctionManager().unregister(id);
        }
        return new JsonBean<Boolean>(success);
    }
}

