/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.controller;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.ssssssss.magicapi.config.MagicConfiguration;
import org.ssssssss.magicapi.config.Valid;
import org.ssssssss.magicapi.controller.MagicController;
import org.ssssssss.magicapi.controller.MagicExceptionHandler;
import org.ssssssss.magicapi.interceptor.Authorization;
import org.ssssssss.magicapi.model.Group;
import org.ssssssss.magicapi.model.JsonBean;
import org.ssssssss.magicapi.model.TreeNode;
import org.ssssssss.magicapi.provider.GroupServiceProvider;
import org.ssssssss.magicapi.utils.IoUtils;

public class MagicGroupController
extends MagicController
implements MagicExceptionHandler {
    private final GroupServiceProvider groupServiceProvider;

    public MagicGroupController(MagicConfiguration configuration) {
        super(configuration);
        this.groupServiceProvider = configuration.getGroupServiceProvider();
    }

    @RequestMapping(value={"/group/delete"})
    @ResponseBody
    @Valid(readonly=false, authorization=Authorization.DELETE)
    public JsonBean<Boolean> deleteGroup(String groupId) {
        boolean success;
        boolean isApi = true;
        TreeNode<Group> treeNode = this.configuration.getGroupServiceProvider().apiGroupTree().findTreeNode(group -> group.getId().equals(groupId));
        if (treeNode == null) {
            treeNode = this.configuration.getGroupServiceProvider().functionGroupTree().findTreeNode(group -> group.getId().equals(groupId));
            this.notNull(treeNode, GROUP_NOT_FOUND);
            isApi = false;
        }
        List<String> children = treeNode.flat().stream().map(Group::getId).collect(Collectors.toList());
        if (isApi) {
            success = this.configuration.getMagicApiService().deleteGroup(groupId, children);
            if (success) {
                this.configuration.getMappingHandlerMapping().deleteGroup(children);
                children.forEach(this.configuration.getGroupServiceProvider()::delete);
                this.configuration.getMappingHandlerMapping().loadGroup();
            }
        } else {
            success = this.configuration.getFunctionServiceProvider().deleteGroup(groupId, children);
            if (success) {
                this.configuration.getMagicFunctionManager().deleteGroup(children);
                children.forEach(this.configuration.getGroupServiceProvider()::delete);
                this.configuration.getMagicFunctionManager().loadGroup();
            }
        }
        return new JsonBean<Boolean>(success);
    }

    @RequestMapping(value={"/group/update"})
    @ResponseBody
    @Valid(readonly=false, authorization=Authorization.SAVE)
    public synchronized JsonBean<Boolean> groupUpdate(Group group) {
        if (StringUtils.isBlank((CharSequence)group.getParentId())) {
            group.setParentId("0");
        }
        this.notBlank(group.getName(), GROUP_NAME_REQUIRED);
        this.isTrue(IoUtils.validateFileName(group.getName()), NAME_INVALID);
        this.notBlank(group.getType(), GROUP_TYPE_REQUIRED);
        boolean isApiGroup = "1".equals(group.getType());
        boolean isFunctionGroup = "2".equals(group.getType());
        if (isApiGroup && this.configuration.getMappingHandlerMapping().checkGroup(group)) {
            this.isTrue(this.groupServiceProvider.update(group), GROUP_SAVE_FAILURE);
            this.configuration.getMappingHandlerMapping().updateGroup(group);
            return new JsonBean<Boolean>(true);
        }
        if (isFunctionGroup && this.configuration.getMagicFunctionManager().checkGroup(group)) {
            this.isTrue(this.groupServiceProvider.update(group), GROUP_SAVE_FAILURE);
            this.configuration.getMagicFunctionManager().updateGroup(group);
            return new JsonBean<Boolean>(true);
        }
        return new JsonBean<Boolean>(GROUP_CONFLICT);
    }

    @RequestMapping(value={"/group/list"})
    @ResponseBody
    @Valid(authorization=Authorization.VIEW)
    public JsonBean<List<Group>> groupList(String type) {
        return new JsonBean<List<Group>>(this.groupServiceProvider.groupList(type));
    }

    @RequestMapping(value={"/group/create"})
    @ResponseBody
    @Valid(readonly=false, authorization=Authorization.SAVE)
    public JsonBean<String> createGroup(Group group) {
        if (StringUtils.isBlank((CharSequence)group.getParentId())) {
            group.setParentId("0");
        }
        this.notBlank(group.getName(), GROUP_NAME_REQUIRED);
        this.isTrue(IoUtils.validateFileName(group.getName()), NAME_INVALID);
        this.notBlank(group.getType(), GROUP_TYPE_REQUIRED);
        this.isTrue(this.groupServiceProvider.insert(group), GROUP_SAVE_FAILURE);
        if (Objects.equals(group.getType(), "1")) {
            this.configuration.getMappingHandlerMapping().loadGroup();
        } else {
            this.configuration.getMagicFunctionManager().loadGroup();
        }
        return new JsonBean<String>(group.getId());
    }
}

