/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.controller;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.ResourceUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;
import org.ssssssss.magicapi.adapter.Resource;
import org.ssssssss.magicapi.adapter.resource.ZipResource;
import org.ssssssss.magicapi.config.MagicConfiguration;
import org.ssssssss.magicapi.config.Valid;
import org.ssssssss.magicapi.controller.MagicController;
import org.ssssssss.magicapi.controller.MagicExceptionHandler;
import org.ssssssss.magicapi.exception.MagicLoginException;
import org.ssssssss.magicapi.interceptor.Authorization;
import org.ssssssss.magicapi.interceptor.MagicUser;
import org.ssssssss.magicapi.logging.MagicLoggerContext;
import org.ssssssss.magicapi.model.ApiInfo;
import org.ssssssss.magicapi.model.FunctionInfo;
import org.ssssssss.magicapi.model.Group;
import org.ssssssss.magicapi.model.JsonBean;
import org.ssssssss.magicapi.model.MagicEntity;
import org.ssssssss.magicapi.model.Options;
import org.ssssssss.magicapi.modules.ResponseModule;
import org.ssssssss.magicapi.modules.SQLModule;
import org.ssssssss.magicapi.provider.GroupServiceProvider;
import org.ssssssss.magicapi.provider.MagicAPIService;
import org.ssssssss.magicapi.provider.StoreServiceProvider;
import org.ssssssss.magicapi.utils.JsonUtils;
import org.ssssssss.magicapi.utils.PathUtils;
import org.ssssssss.script.MagicResourceLoader;
import org.ssssssss.script.MagicScriptEngine;
import org.ssssssss.script.ScriptClass;

public class MagicWorkbenchController
extends MagicController
implements MagicExceptionHandler {
    private static final Logger logger = LoggerFactory.getLogger(MagicWorkbenchController.class);

    public MagicWorkbenchController(MagicConfiguration configuration) {
        super(configuration);
        MagicScriptEngine.addScriptClass(SQLModule.class);
        MagicScriptEngine.addScriptClass(MagicAPIService.class);
    }

    @RequestMapping(value={"/classes"})
    @ResponseBody
    @Valid(requireLogin=false)
    public JsonBean<Map<String, Object>> classes() {
        Map classMap = MagicScriptEngine.getScriptClassMap();
        classMap.putAll(MagicResourceLoader.getModules());
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("classes", classMap);
        values.put("extensions", MagicScriptEngine.getExtensionScriptClass());
        values.put("functions", MagicScriptEngine.getFunctions());
        return new JsonBean<Map<String, Object>>(values);
    }

    @RequestMapping(value={"/class"})
    @ResponseBody
    public JsonBean<List<ScriptClass>> clazz(String className) {
        return new JsonBean<List<ScriptClass>>(MagicScriptEngine.getScriptClass((String)className));
    }

    @RequestMapping(value={"/login"})
    @ResponseBody
    @Valid(requireLogin=false)
    public JsonBean<Boolean> login(String username, String password, HttpServletRequest request, HttpServletResponse response) throws MagicLoginException {
        if (this.configuration.getAuthorizationInterceptor().requireLogin()) {
            if (StringUtils.isBlank((CharSequence)username) && StringUtils.isBlank((CharSequence)password)) {
                try {
                    this.configuration.getAuthorizationInterceptor().getUserByToken(request.getHeader("Magic-Token"));
                }
                catch (MagicLoginException ignored) {
                    return new JsonBean<Boolean>(false);
                }
            } else {
                MagicUser user = this.configuration.getAuthorizationInterceptor().login(username, password);
                response.setHeader("Magic-Token", user.getToken());
                response.setHeader("Access-Control-Expose-Headers", "Magic-Token");
            }
        }
        return new JsonBean<Boolean>(true);
    }

    @RequestMapping(value={"/console"})
    @Valid(requireLogin=false)
    public SseEmitter console() throws IOException {
        String sessionId = UUID.randomUUID().toString().replace("-", "");
        SseEmitter emitter = MagicLoggerContext.createEmitter(sessionId);
        emitter.send(SseEmitter.event().data((Object)sessionId).name("create"));
        return emitter;
    }

    @RequestMapping(value={"/options"})
    @ResponseBody
    @Valid(requireLogin=false)
    public JsonBean<List<List<String>>> options() {
        return new JsonBean<List<List<String>>>(Stream.of(Options.values()).map(item -> Arrays.asList(item.getValue(), item.getName(), item.getDefaultValue())).collect(Collectors.toList()));
    }

    @RequestMapping(value={"/config-js"})
    @ResponseBody
    @Valid(requireLogin=false)
    public ResponseEntity<?> configJs() {
        ResponseEntity.BodyBuilder responseBuilder = ResponseEntity.ok().contentType(MediaType.parseMediaType((String)"application/javascript"));
        if (this.configuration.getEditorConfig() != null) {
            try {
                String path = this.configuration.getEditorConfig();
                if (path.startsWith("classpath:")) {
                    path = path.substring("classpath:".length());
                    return responseBuilder.body((Object)new InputStreamResource(new ClassPathResource(path).getInputStream()));
                }
                File file = ResourceUtils.getFile((String)this.configuration.getEditorConfig());
                return responseBuilder.body((Object)Files.readAllBytes(Paths.get(file.toURI())));
            }
            catch (IOException e) {
                logger.warn("\u8bfb\u53d6\u7f16\u8f91\u5668\u914d\u7f6e\u6587\u4ef6{}\u5931\u8d25", (Object)this.configuration.getEditorConfig());
            }
        }
        return responseBuilder.body((Object)"var MAGIC_EDITOR_CONFIG = {}".getBytes());
    }

    @RequestMapping(value={"/download"})
    @Valid(authorization=Authorization.DOWNLOAD)
    @ResponseBody
    public ResponseEntity<?> download(String groupId) throws IOException {
        if (StringUtils.isBlank((CharSequence)groupId)) {
            return this.download(this.configuration.getWorkspace(), "magic-api-all.zip");
        }
        Resource resource = this.configuration.getGroupServiceProvider().getGroupResource(groupId);
        this.notNull(resource, GROUP_NOT_FOUND);
        return this.download(resource, "magic-api-group.zip");
    }

    @RequestMapping(value={"/upload"})
    @Valid(readonly=false, authorization=Authorization.UPLOAD)
    @ResponseBody
    public JsonBean<Boolean> upload(MultipartFile file, String mode) throws IOException {
        this.notNull(file, FILE_IS_REQUIRED);
        ZipResource root = new ZipResource(file.getInputStream());
        HashSet<String> apiPaths = new HashSet<String>();
        HashSet<String> functionPaths = new HashSet<String>();
        HashSet<Group> groups = new HashSet<Group>();
        HashSet<ApiInfo> apiInfos = new HashSet<ApiInfo>();
        HashSet<FunctionInfo> functionInfos = new HashSet<FunctionInfo>();
        this.isTrue(this.readPaths(groups, apiPaths, functionPaths, apiInfos, functionInfos, "/", root), UPLOAD_PATH_CONFLICT);
        if (!"force".equals(mode)) {
            this.isTrue(!this.configuration.getMappingHandlerMapping().hasRegister(apiPaths), UPLOAD_PATH_CONFLICT.format("\u63a5\u53e3"));
            this.isTrue(!this.configuration.getMagicFunctionManager().hasRegister(apiPaths), UPLOAD_PATH_CONFLICT.format("\u51fd\u6570"));
        }
        Resource item = root.getResource("group.json");
        GroupServiceProvider groupServiceProvider = this.configuration.getGroupServiceProvider();
        if (item.exists()) {
            Group group = groupServiceProvider.readGroup(item);
            this.isTrue("0".equals(group.getParentId()) || groupServiceProvider.getGroupResource(group.getParentId()).exists(), GROUP_NOT_FOUND);
            groups.removeIf(it -> it.getId().equalsIgnoreCase(group.getId()));
        }
        for (Group group : groups) {
            Resource groupResource = groupServiceProvider.getGroupResource(group.getId());
            if (groupResource != null && groupResource.exists()) {
                groupServiceProvider.update(group);
                continue;
            }
            groupServiceProvider.insert(group);
        }
        Resource backups = this.configuration.getWorkspace().getDirectory("backups");
        this.write(this.configuration.getMagicApiService(), backups, apiInfos);
        this.write(this.configuration.getFunctionServiceProvider(), backups, functionInfos);
        this.configuration.getMappingHandlerMapping().registerAllMapping();
        this.configuration.getMagicFunctionManager().registerAllFunction();
        return new JsonBean<Boolean>(SUCCESS, true);
    }

    private <T extends MagicEntity> void write(StoreServiceProvider<T> provider, Resource backups, Set<T> infos) {
        for (MagicEntity info : infos) {
            Resource resource = this.configuration.getGroupServiceProvider().getGroupResource(info.getGroupId());
            resource = resource.getResource(info.getName() + ".ms");
            byte[] content = provider.serialize(info);
            resource.write(content);
            Resource directory = backups.getDirectory(info.getId());
            if (!directory.exists()) {
                directory.mkdir();
            }
            directory.getResource(System.currentTimeMillis() + ".ms").write(content);
            resource.write(content);
        }
    }

    private boolean readPaths(Set<Group> groups, Set<String> apiPaths, Set<String> functionPaths, Set<ApiInfo> apiInfos, Set<FunctionInfo> functionInfos, String parentPath, Resource root) {
        Resource resource = root.getResource("group.json");
        String path = "";
        if (resource.exists()) {
            Group group = JsonUtils.readValue(resource.read(), Group.class);
            groups.add(group);
            path = Objects.toString(group.getPath(), "");
            boolean isApi = "1".equals(group.getType());
            for (Resource file : root.files(".ms")) {
                boolean conflict;
                MagicEntity info;
                if (isApi) {
                    info = (ApiInfo)this.configuration.getMagicApiService().deserialize(file.read());
                    apiInfos.add((ApiInfo)info);
                    conflict = !apiPaths.add(Objects.toString(((ApiInfo)info).getMethod(), "GET") + ":" + PathUtils.replaceSlash(parentPath + "/" + path + "/" + ((ApiInfo)info).getPath()));
                } else {
                    info = (FunctionInfo)this.configuration.getFunctionServiceProvider().deserialize(file.read());
                    functionInfos.add((FunctionInfo)info);
                    boolean bl = conflict = !functionPaths.add(PathUtils.replaceSlash(parentPath + "/" + path + "/" + ((FunctionInfo)info).getPath()));
                }
                if (!conflict) continue;
                return false;
            }
        }
        for (Resource directory : root.dirs()) {
            if (this.readPaths(groups, apiPaths, functionPaths, apiInfos, functionInfos, PathUtils.replaceSlash(parentPath + "/" + path), directory)) continue;
            return false;
        }
        return true;
    }

    private ResponseEntity<?> download(Resource resource, String filename) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        resource.export(os, "backups");
        return ResponseModule.download(os.toByteArray(), filename);
    }
}

