/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import org.springframework.core.io.InputStreamSource;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.ssssssss.magicapi.config.MagicConfiguration;
import org.ssssssss.magicapi.config.Valid;
import org.ssssssss.magicapi.context.CookieContext;
import org.ssssssss.magicapi.context.HeaderContext;
import org.ssssssss.magicapi.context.RequestContext;
import org.ssssssss.magicapi.context.SessionContext;
import org.ssssssss.magicapi.controller.MagicController;
import org.ssssssss.magicapi.interceptor.RequestInterceptor;
import org.ssssssss.magicapi.logging.LogInfo;
import org.ssssssss.magicapi.logging.MagicLoggerContext;
import org.ssssssss.magicapi.model.BaseDefinition;
import org.ssssssss.magicapi.model.DataType;
import org.ssssssss.magicapi.model.JsonBean;
import org.ssssssss.magicapi.model.JsonBodyBean;
import org.ssssssss.magicapi.model.JsonCode;
import org.ssssssss.magicapi.model.Options;
import org.ssssssss.magicapi.model.RequestEntity;
import org.ssssssss.magicapi.modules.ResponseModule;
import org.ssssssss.magicapi.provider.ResultProvider;
import org.ssssssss.magicapi.script.ScriptManager;
import org.ssssssss.magicapi.utils.PatternUtils;
import org.ssssssss.script.MagicScriptContext;
import org.ssssssss.script.MagicScriptDebugContext;
import org.ssssssss.script.exception.MagicScriptAssertException;
import org.ssssssss.script.exception.MagicScriptException;
import org.ssssssss.script.functions.ObjectConvertExtension;
import org.ssssssss.script.parsing.Span;
import org.ssssssss.script.parsing.ast.literal.BooleanLiteral;
import org.ssssssss.script.reflection.JavaInvoker;

public class RequestHandler
extends MagicController {
    private static final Logger logger = LoggerFactory.getLogger(RequestHandler.class);
    private final ResultProvider resultProvider;

    public RequestHandler(MagicConfiguration configuration) {
        super(configuration);
        this.resultProvider = configuration.getResultProvider();
    }

    @ResponseBody
    @Valid(requireLogin=false)
    public Object invoke(final HttpServletRequest request, HttpServletResponse response, @PathVariable(required=false) Map<String, Object> pathVariables, @RequestParam(required=false) Map<String, Object> parameters) throws Throwable {
        RequestEntity requestEntity = new RequestEntity(request, response, this.isRequestedFromTest(request), parameters, pathVariables);
        if (requestEntity.isRequestedFromTest()) {
            response.setHeader("Response-With-Magic-API", "true");
            response.setHeader("Access-Control-Expose-Headers", "Response-With-Magic-API");
        }
        if (requestEntity.getApiInfo() == null) {
            logger.error("{}\u627e\u4e0d\u5230\u5bf9\u5e94\u63a5\u53e3", (Object)request.getRequestURI());
            return this.buildResult(requestEntity, API_NOT_FOUND, "\u63a5\u53e3\u4e0d\u5b58\u5728");
        }
        Object value = this.doValidate(requestEntity, "\u53c2\u6570", requestEntity.getApiInfo().getParameters(), parameters);
        if (value != null) {
            return requestEntity.isRequestedFromTest() ? new JsonBean<Object>(PARAMETER_INVALID, value) : value;
        }
        HashMap<String, Object> headers = new HashMap<String, Object>(){

            @Override
            public Object get(Object key) {
                return this.getOrDefault(key, request.getHeader(key.toString()));
            }
        };
        requestEntity.setHeaders((Map<String, Object>)headers);
        value = this.doValidate(requestEntity, "header", requestEntity.getApiInfo().getHeaders(), (Map<String, Object>)headers);
        if (value != null) {
            return requestEntity.isRequestedFromTest() ? new JsonBean<Object>(HEADER_INVALID, value) : value;
        }
        value = this.doValidate(requestEntity, "path", requestEntity.getApiInfo().getPaths(), requestEntity.getPathVariables());
        if (value != null) {
            return requestEntity.isRequestedFromTest() ? new JsonBean<Object>(PATH_VARIABLE_INVALID, value) : value;
        }
        MagicScriptContext context = this.createMagicScriptContext(requestEntity);
        requestEntity.setMagicScriptContext(context);
        value = this.doPreHandle(requestEntity);
        if (value != null) {
            if (requestEntity.isRequestedFromTest()) {
                response.setHeader("Response-With-Magic-API", "false");
            }
            return value;
        }
        if (requestEntity.isRequestedFromTest()) {
            return this.isRequestedFromContinue(request) ? this.invokeContinueRequest(requestEntity) : this.invokeTestRequest(requestEntity);
        }
        return this.invokeRequest(requestEntity);
    }

    private Object buildResult(RequestEntity requestEntity, JsonCode code, Object data) {
        return this.resultProvider.buildResult(requestEntity, code.getCode(), code.getMessage(), data);
    }

    private <T extends BaseDefinition> Object doValidate(RequestEntity requestEntity, String comment, List<T> validateParameters, Map<String, Object> parameters) {
        for (BaseDefinition parameter : validateParameters) {
            if (!StringUtils.isNotBlank((CharSequence)parameter.getName())) continue;
            String requestValue = (String)StringUtils.defaultIfBlank((CharSequence)Objects.toString(parameters.get(parameter.getName()), ""), (CharSequence)Objects.toString(parameter.getDefaultValue(), ""));
            if (StringUtils.isBlank((CharSequence)requestValue)) {
                if (!parameter.isRequired()) continue;
                return this.resultProvider.buildResult(requestEntity, 0, (String)StringUtils.defaultIfBlank((CharSequence)parameter.getError(), (CharSequence)String.format("%s[%s]\u4e3a\u5fc5\u586b\u9879", comment, parameter.getName())));
            }
            try {
                String expression;
                Object value = this.convertValue(parameter.getDataType(), parameter.getName(), requestValue);
                String validateType = parameter.getValidateType();
                if ("pattern".equals(validateType) && StringUtils.isNotBlank((CharSequence)(expression = parameter.getExpression())) && !PatternUtils.match(Objects.toString(value, ""), expression)) {
                    return this.resultProvider.buildResult(requestEntity, 0, (String)StringUtils.defaultIfBlank((CharSequence)parameter.getError(), (CharSequence)String.format("%s[%s]\u4e0d\u6ee1\u8db3\u6b63\u5219\u8868\u8fbe\u5f0f", comment, parameter.getName())));
                }
                parameters.put(parameter.getName(), value);
            }
            catch (Exception e) {
                return this.resultProvider.buildResult(requestEntity, 0, (String)StringUtils.defaultIfBlank((CharSequence)parameter.getError(), (CharSequence)String.format("%s[%s]\u4e0d\u5408\u6cd5", comment, parameter.getName())));
            }
        }
        List validates = validateParameters.stream().filter(it -> "expression".equals(it.getValidateType()) && StringUtils.isNotBlank((CharSequence)it.getExpression())).collect(Collectors.toList());
        for (BaseDefinition parameter : validates) {
            MagicScriptContext context = new MagicScriptContext();
            context.putMapIntoContext(parameters);
            context.set("value", parameters.get(parameter.getName()));
            if (BooleanLiteral.isTrue((Object)ScriptManager.executeExpression(parameter.getExpression(), context))) continue;
            return this.resultProvider.buildResult(requestEntity, 0, (String)StringUtils.defaultIfBlank((CharSequence)parameter.getError(), (CharSequence)String.format("%s[%s]\u4e0d\u6ee1\u8db3\u8868\u8fbe\u5f0f", comment, parameter.getName())));
        }
        return null;
    }

    private Object convertValue(DataType dataType, String name, String value) {
        if (dataType == null) {
            return value;
        }
        try {
            if (dataType.isNumber()) {
                BigDecimal decimal = ObjectConvertExtension.asDecimal((Object)value, null);
                if (decimal == null) {
                    throw new IllegalArgumentException();
                }
                return dataType.getInvoker().invoke0((Object)decimal, null, new Object[0]);
            }
            JavaInvoker<Method> invoker = dataType.getInvoker();
            if (invoker != null) {
                ArrayList<String> params = new ArrayList<String>();
                if (dataType.isNeedName()) {
                    params.add(name);
                }
                if (dataType.isNeedValue()) {
                    params.add(value);
                }
                return invoker.invoke0(null, null, params.toArray());
            }
            return value;
        }
        catch (Throwable throwable) {
            throw new IllegalArgumentException();
        }
    }

    private Object invokeContinueRequest(RequestEntity requestEntity) throws Exception {
        HttpServletRequest request = requestEntity.getRequest();
        String sessionId = this.getRequestedSessionId(request);
        MagicScriptDebugContext context = MagicScriptDebugContext.getDebugContext((String)sessionId);
        if (context == null) {
            return new JsonBean<Object>(DEBUG_SESSION_NOT_FOUND, this.buildResult(requestEntity, DEBUG_SESSION_NOT_FOUND, null));
        }
        context.setBreakpoints(this.getRequestedBreakpoints(request));
        context.setStepInto("true".equalsIgnoreCase(request.getHeader("Magic-Request-Step-Into")));
        try {
            context.singal();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (context.isRunning()) {
            return new JsonBodyBean<Object>(1000, context.getId(), this.resultProvider.buildResult(requestEntity, 1000, context.getId()), context.getDebugInfo());
        }
        if (context.isException()) {
            return this.resolveThrowable(requestEntity, (Throwable)context.getReturnValue());
        }
        Object value = context.getReturnValue();
        if ((value = this.doPostHandle(requestEntity, value)) != null) {
            requestEntity.getResponse().setHeader("Response-With-Magic-API", "false");
            return value;
        }
        return this.convertResult(requestEntity, context.getReturnValue());
    }

    private Object invokeTestRequest(RequestEntity requestEntity) {
        try {
            MagicScriptDebugContext context = this.initializeDebug(requestEntity);
            Object result = ScriptManager.executeScript(requestEntity.getApiInfo().getScript(), requestEntity.getMagicScriptContext());
            if (context.isRunning()) {
                return new JsonBodyBean<Object>(1000, context.getId(), this.resultProvider.buildResult(requestEntity, 1000, context.getId(), result), result);
            }
            if (context.isException()) {
                return this.resolveThrowable(requestEntity, (Throwable)context.getReturnValue());
            }
            Object value = result;
            if ((value = this.doPostHandle(requestEntity, value)) != null) {
                requestEntity.getResponse().setHeader("Response-With-Magic-API", "false");
                return value;
            }
            return this.convertResult(requestEntity, result);
        }
        catch (Exception e) {
            return this.resolveThrowable(requestEntity, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object invokeRequest(RequestEntity requestEntity) throws Throwable {
        HttpServletRequest request = requestEntity.getRequest();
        try {
            Object result;
            RequestContext.setRequestAttribute(request, requestEntity.getResponse());
            Object value = result = ScriptManager.executeScript(requestEntity.getApiInfo().getScript(), requestEntity.getMagicScriptContext());
            value = this.doPostHandle(requestEntity, value);
            if (value != null) {
                Object object = value;
                return object;
            }
            Object object = this.response(requestEntity, result);
            return object;
        }
        catch (Throwable root) {
            Throwable parent = root;
            do {
                if (!(parent instanceof MagicScriptAssertException)) continue;
                MagicScriptAssertException sae = (MagicScriptAssertException)parent;
                Object object = this.resultProvider.buildResult(requestEntity, sae.getCode(), sae.getMessage());
                return object;
            } while ((parent = parent.getCause()) != null);
            if (this.configuration.isThrowException()) {
                throw root;
            }
            logger.error("\u63a5\u53e3{}\u8bf7\u6c42\u51fa\u9519", (Object)request.getRequestURI(), (Object)root);
            Object object = this.resultProvider.buildResult(requestEntity, -1, "\u7cfb\u7edf\u5185\u90e8\u51fa\u73b0\u9519\u8bef");
            return object;
        }
        finally {
            RequestContext.remove();
        }
    }

    private Object convertResult(RequestEntity requestEntity, Object result) throws IOException {
        if (result instanceof ResponseEntity) {
            ResponseEntity entity = (ResponseEntity)result;
            ArrayList<String> headers = new ArrayList<String>();
            for (Map.Entry entry : entity.getHeaders().entrySet()) {
                String key = (String)entry.getKey();
                for (String value : (List)entry.getValue()) {
                    headers.add("MA-" + key);
                    requestEntity.getResponse().addHeader("MA-" + key, value);
                }
            }
            headers.add("Response-With-Magic-API");
            requestEntity.getResponse().setHeader("Access-Control-Expose-Headers", String.join((CharSequence)",", headers));
            if (entity.getHeaders().isEmpty()) {
                return ResponseEntity.ok(new JsonBean<Object>(entity.getBody()));
            }
            return ResponseEntity.ok(new JsonBean<String>(this.convertToBase64(entity.getBody())));
        }
        if (result instanceof ResponseModule.NullValue) {
            return new JsonBean(1, "empty.");
        }
        return new JsonBean<Object>(this.resultProvider.buildResult(requestEntity, result));
    }

    private String convertToBase64(Object value) throws IOException {
        if (value instanceof String || value instanceof Number) {
            return this.convertToBase64(value.toString().getBytes());
        }
        if (value instanceof byte[]) {
            return Base64.getEncoder().encodeToString((byte[])value);
        }
        if (value instanceof InputStream) {
            return this.convertToBase64(IOUtils.toByteArray((InputStream)((InputStream)value)));
        }
        if (value instanceof InputStreamSource) {
            InputStreamSource iss = (InputStreamSource)value;
            return this.convertToBase64(iss.getInputStream());
        }
        return this.convertToBase64(new ObjectMapper().writeValueAsString(value));
    }

    private JsonBean<Object> resolveThrowable(RequestEntity requestEntity, Throwable root) {
        MagicScriptException se = null;
        Throwable parent = root;
        do {
            if (parent instanceof MagicScriptAssertException) {
                MagicScriptAssertException sae = (MagicScriptAssertException)parent;
                return new JsonBean<Object>(this.resultProvider.buildResult(requestEntity, sae.getCode(), sae.getMessage()));
            }
            if (!(parent instanceof MagicScriptException)) continue;
            se = (MagicScriptException)parent;
        } while ((parent = parent.getCause()) != null);
        logger.error("\u6d4b\u8bd5\u811a\u672c\u51fa\u9519", root);
        if (se != null) {
            Span.Line line = se.getLine();
            return new JsonBodyBean<Object>(-1000, se.getSimpleMessage(), this.resultProvider.buildResult(requestEntity, -1000, se.getSimpleMessage()), line == null ? null : Arrays.asList(line.getLineNumber(), line.getEndLineNumber(), line.getStartCol(), line.getEndCol()));
        }
        return new JsonBean<Object>(-1, root.getMessage(), this.resultProvider.buildResult(requestEntity, -1, root.getMessage()));
    }

    private MagicScriptDebugContext initializeDebug(RequestEntity requestEntity) {
        MagicScriptDebugContext context = (MagicScriptDebugContext)requestEntity.getMagicScriptContext();
        HttpServletRequest request = requestEntity.getRequest();
        RequestContextHolder.setRequestAttributes((RequestAttributes)RequestContextHolder.getRequestAttributes(), (boolean)true);
        String sessionId = this.getRequestedSessionId(request);
        context.setBreakpoints(this.getRequestedBreakpoints(request));
        context.setTimeout(this.configuration.getDebugTimeout());
        context.setId(sessionId);
        context.onComplete(() -> {
            if (context.isException()) {
                MagicLoggerContext.println(new LogInfo(Level.ERROR.name().toLowerCase(), "\u6267\u884c\u811a\u672c\u51fa\u9519", (Throwable)context.getReturnValue()));
            }
            logger.info("Close Console Session : {}", (Object)sessionId);
            RequestContext.remove();
            MagicLoggerContext.remove(sessionId);
        });
        context.onStart(() -> {
            RequestContext.setRequestAttribute(request, requestEntity.getResponse());
            MagicLoggerContext.SESSION.set(sessionId);
            logger.info("Create Console Session : {}", (Object)sessionId);
        });
        return context;
    }

    private boolean isRequestedFromTest(HttpServletRequest request) {
        return this.configuration.isEnableWeb() && request.getHeader("Magic-Request-Session") != null;
    }

    private boolean isRequestedFromContinue(HttpServletRequest request) {
        return request.getHeader("Magic-Request-Continue") != null;
    }

    private String getRequestedSessionId(HttpServletRequest request) {
        return request.getHeader("Magic-Request-Session");
    }

    private List<Integer> getRequestedBreakpoints(HttpServletRequest request) {
        String breakpoints = request.getHeader("Magic-Request-Breakpoints");
        if (breakpoints != null) {
            return Arrays.stream(breakpoints.split(",")).map(val -> ObjectConvertExtension.asInt((Object)val, (int)-1)).collect(Collectors.toList());
        }
        return null;
    }

    private Object readRequestBody(HttpServletRequest request) throws IOException {
        if (this.configuration.getHttpMessageConverters() != null && request.getContentType() != null) {
            MediaType mediaType = MediaType.valueOf((String)request.getContentType());
            Class<Object> clazz = Object.class;
            try {
                for (HttpMessageConverter<?> converter : this.configuration.getHttpMessageConverters()) {
                    if (!converter.canRead(clazz, mediaType)) continue;
                    return converter.read(clazz, (HttpInputMessage)new ServletServerHttpRequest(request));
                }
            }
            catch (HttpMessageNotReadableException ignored) {
                return null;
            }
        }
        return null;
    }

    private MagicScriptContext createMagicScriptContext(RequestEntity requestEntity) throws IOException {
        MagicScriptDebugContext context = requestEntity.isRequestedFromTest() ? new MagicScriptDebugContext() : new MagicScriptContext();
        String wrap = requestEntity.getApiInfo().getOptionValue(Options.WRAP_REQUEST_PARAMETERS.getValue());
        if (wrap != null && StringUtils.isNotBlank((CharSequence)wrap.toString())) {
            context.set(wrap.toString(), requestEntity.getParameters());
        }
        context.putMapIntoContext(requestEntity.getParameters());
        context.putMapIntoContext(requestEntity.getPathVariables());
        context.set("cookie", (Object)new CookieContext(requestEntity.getRequest()));
        context.set("header", (Object)new HeaderContext(requestEntity.getHeaders()));
        context.set("session", (Object)new SessionContext(requestEntity.getRequest().getSession()));
        context.set("path", requestEntity.getPathVariables());
        Object requestBody = this.readRequestBody(requestEntity.getRequest());
        if (requestBody != null) {
            context.set("body", requestBody);
        }
        return context;
    }

    private Object response(RequestEntity requestEntity, Object value) {
        if (value instanceof ResponseEntity) {
            return value;
        }
        if (value instanceof ResponseModule.NullValue) {
            return null;
        }
        return this.resultProvider.buildResult(requestEntity, value);
    }

    private Object doPostHandle(RequestEntity requestEntity, Object value) throws Exception {
        for (RequestInterceptor requestInterceptor : this.configuration.getRequestInterceptors()) {
            Object target = requestInterceptor.postHandle(requestEntity, value);
            if (target == null) continue;
            return target;
        }
        return null;
    }

    private Object doPreHandle(RequestEntity requestEntity) throws Exception {
        for (RequestInterceptor requestInterceptor : this.configuration.getRequestInterceptors()) {
            Object value = requestInterceptor.preHandle(requestEntity);
            if (value == null) continue;
            return value;
        }
        return null;
    }
}

