/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.logging;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.impl.ThrowableProxy;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.ssssssss.magicapi.logging.LogInfo;
import org.ssssssss.magicapi.logging.MagicLoggerContext;

public class Log4j2LoggerContext
implements MagicLoggerContext {
    @Override
    public void generateAppender() {
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration configuration = context.getConfiguration();
        LoggerConfig logger = configuration.getRootLogger();
        PatternLayout layout = PatternLayout.newBuilder().withCharset(StandardCharsets.UTF_8).withConfiguration(configuration).withPattern("%d %t %p %X{TracingMsg} %c - %m%n").build();
        MagicLog4j2Appender appender = new MagicLog4j2Appender("Magic", logger.getFilter(), (Layout<? extends Serializable>)layout);
        appender.start();
        configuration.addAppender((Appender)appender);
        logger.addAppender((Appender)appender, logger.getLevel(), logger.getFilter());
        context.updateLoggers(configuration);
    }

    static class MagicLog4j2Appender
    extends AbstractAppender {
        MagicLog4j2Appender(String name, Filter filter, Layout<? extends Serializable> layout) {
            super(name, filter, layout, true, Property.EMPTY_ARRAY);
        }

        public void append(LogEvent event) {
            LogInfo logInfo = new LogInfo();
            logInfo.setLevel(event.getLevel().name().toLowerCase());
            logInfo.setMessage(event.getMessage().getFormattedMessage());
            ThrowableProxy throwableProxy = event.getThrownProxy();
            if (throwableProxy != null) {
                logInfo.setThrowable(throwableProxy.getThrowable());
            }
            MagicLoggerContext.println(logInfo);
        }
    }
}

