/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.logging;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import org.slf4j.LoggerFactory;
import org.ssssssss.magicapi.logging.LogInfo;
import org.ssssssss.magicapi.logging.MagicLoggerContext;

public class LogbackLoggerContext
implements MagicLoggerContext {
    @Override
    public void generateAppender() {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        Logger logger = context.getLogger("ROOT");
        MagicLogbackAppender appender = new MagicLogbackAppender();
        appender.setContext((Context)context);
        appender.setName("MagicAPI");
        appender.start();
        logger.addAppender((Appender)appender);
    }

    static class MagicLogbackAppender
    extends UnsynchronizedAppenderBase<ILoggingEvent> {
        MagicLogbackAppender() {
        }

        protected void append(ILoggingEvent event) {
            LogInfo logInfo = new LogInfo();
            logInfo.setLevel(event.getLevel().levelStr.toLowerCase());
            logInfo.setMessage(event.getFormattedMessage());
            ThrowableProxy throwableProxy = (ThrowableProxy)event.getThrowableProxy();
            if (throwableProxy != null) {
                logInfo.setThrowable(throwableProxy.getThrowable());
            }
            MagicLoggerContext.println(logInfo);
        }
    }
}

