/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.logging;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;
import org.ssssssss.magicapi.logging.LogInfo;
import org.ssssssss.script.MagicScriptContext;
import org.ssssssss.script.MagicScriptDebugContext;

public interface MagicLoggerContext {
    public static final String LOGGER_NAME = "MagicAPI";
    public static final Map<String, SseEmitter> emitterMap = new ConcurrentHashMap<String, SseEmitter>();
    public static final ThreadLocal<String> SESSION = new InheritableThreadLocal<String>();

    public static SseEmitter createEmitter(String sessionId) {
        SseEmitter sseEmitter = new SseEmitter(Long.valueOf(0L));
        emitterMap.put(sessionId, sseEmitter);
        return sseEmitter;
    }

    public static void remove(String sessionId) {
        SseEmitter sseEmitter = emitterMap.remove(sessionId);
        SESSION.remove();
        if (sseEmitter != null) {
            try {
                sseEmitter.send(SseEmitter.event().data((Object)sessionId).name("close"));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void println(LogInfo logInfo) {
        SseEmitter sseEmitter;
        MagicScriptContext context = MagicScriptContext.get();
        String sessionId = context instanceof MagicScriptDebugContext ? ((MagicScriptDebugContext)context).getId() : SESSION.get();
        if (sessionId != null && (sseEmitter = emitterMap.get(sessionId)) != null) {
            try {
                sseEmitter.send(SseEmitter.event().data((Object)logInfo).name("log"));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void generateAppender();
}

