/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.model;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.ssssssss.magicapi.model.Header;
import org.ssssssss.magicapi.model.MagicEntity;
import org.ssssssss.magicapi.model.Options;
import org.ssssssss.magicapi.model.Parameter;
import org.ssssssss.magicapi.model.Path;
import org.ssssssss.magicapi.utils.JsonUtils;

public class ApiInfo
extends MagicEntity {
    private String method = "GET";
    private String path;
    private List<Parameter> parameters = Collections.emptyList();
    private String option;
    private String requestBody;
    private List<Header> headers = Collections.emptyList();
    private List<Path> paths = Collections.emptyList();
    private String responseBody;
    private String description;
    private transient JsonNode jsonNode;

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setParameter(String parameter) {
        if (parameter != null) {
            if ((parameter = parameter.trim()).startsWith("[")) {
                this.parameters = JsonUtils.readValue(Objects.toString(parameter, "[]"), new TypeReference<List<Parameter>>(){});
            } else {
                Object header;
                Map map = JsonUtils.readValue(Objects.toString(parameter, "{}"), Map.class);
                Object request = map.get("request");
                if (request instanceof Map) {
                    Map requestMap = (Map)request;
                    Set keys = requestMap.keySet();
                    this.parameters = new ArrayList<Parameter>();
                    for (Object key : keys) {
                        this.parameters.add(new Parameter(key.toString(), Objects.toString(requestMap.get(key), "")));
                    }
                }
                if ((header = map.get("header")) instanceof Map) {
                    Map headers = (Map)header;
                    Set keys = headers.keySet();
                    this.headers = new ArrayList<Header>();
                    for (Object key : keys) {
                        this.headers.add(new Header(key.toString(), Objects.toString(headers.get(key), "")));
                    }
                }
                if (map.containsKey("body")) {
                    this.requestBody = Objects.toString(map.get("body"), null);
                }
            }
        }
    }

    public String getResponseBody() {
        return this.responseBody;
    }

    public String getRequestBody() {
        return this.requestBody;
    }

    public void setRequestBody(String requestBody) {
        this.requestBody = requestBody;
    }

    public void setResponseBody(String responseBody) {
        this.responseBody = responseBody;
    }

    public List<Path> getPaths() {
        return this.paths;
    }

    public void setPaths(List<Path> paths) {
        this.paths = paths;
    }

    public Map<String, Object> getOptionMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.jsonNode == null) {
            return null;
        }
        if (this.jsonNode.isArray()) {
            for (JsonNode node : this.jsonNode) {
                map.put(node.get("name").asText(), node.get("value").asText());
            }
        } else {
            this.jsonNode.fieldNames().forEachRemaining(it -> map.put((String)it, this.jsonNode.get(it)));
        }
        return map;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getOption() {
        return this.option;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    public void setRequestHeader(String requestHeader) {
        this.headers = JsonUtils.readValue(Objects.toString(requestHeader, "[]"), new TypeReference<List<Header>>(){});
    }

    public List<Header> getHeaders() {
        return this.headers;
    }

    public void setHeaders(List<Header> headers) {
        this.headers = headers;
    }

    public void setOptionValue(String optionValue) {
        this.setOption(optionValue);
    }

    public void setOption(String option) {
        this.option = option;
        try {
            this.jsonNode = new ObjectMapper().readTree(option);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String getOptionValue(Options options) {
        return this.getOptionValue(options.getValue());
    }

    public String getOptionValue(String key) {
        if (this.jsonNode == null) {
            return null;
        }
        if (this.jsonNode.isArray()) {
            for (JsonNode node : this.jsonNode) {
                if (!node.isObject() || !Objects.equals(key, node.get("name").asText())) continue;
                return node.get("value").asText();
            }
        } else if (this.jsonNode.isObject()) {
            return this.jsonNode.get(key).asText();
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiInfo apiInfo = (ApiInfo)o;
        return Objects.equals(this.id, apiInfo.id) && Objects.equals(this.method, apiInfo.method) && Objects.equals(this.path, apiInfo.path) && Objects.equals(this.script, apiInfo.script) && Objects.equals(this.name, apiInfo.name) && Objects.equals(this.paths, apiInfo.paths) && Objects.equals(this.groupId, apiInfo.groupId) && Objects.equals(this.parameters, apiInfo.parameters) && Objects.equals(this.option, apiInfo.option) && Objects.equals(this.requestBody, apiInfo.requestBody) && Objects.equals(this.headers, apiInfo.headers) && Objects.equals(this.description, apiInfo.description);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.method, this.path, this.script, this.name, this.groupId, this.parameters, this.option, this.requestBody, this.headers, this.responseBody, this.description);
    }

    public ApiInfo copy() {
        ApiInfo info = new ApiInfo();
        info.setId(this.id);
        info.setMethod(this.method);
        info.setName(this.name);
        info.setPath(this.path);
        info.setScript(this.script);
        info.setGroupId(this.groupId);
        info.setParameters(this.parameters);
        info.setOption(this.option);
        info.setRequestBody(this.requestBody);
        info.setHeaders(this.headers);
        info.setResponseBody(this.responseBody);
        info.setDescription(this.description);
        info.setPaths(this.paths);
        return info;
    }
}

