/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.model;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ssssssss.magicapi.config.MappingHandlerMapping;
import org.ssssssss.magicapi.model.ApiInfo;
import org.ssssssss.script.MagicScriptContext;

public class RequestEntity {
    private final ApiInfo apiInfo;
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final boolean requestedFromTest;
    private final Map<String, Object> parameters;
    private final Map<String, Object> pathVariables;
    private MagicScriptContext magicScriptContext;
    private Map<String, Object> headers;
    private final Long requestTime = System.currentTimeMillis();

    private RequestEntity() {
        this.request = null;
        this.response = null;
        this.requestedFromTest = false;
        this.parameters = null;
        this.pathVariables = null;
        this.apiInfo = null;
    }

    public RequestEntity(HttpServletRequest request, HttpServletResponse response, boolean requestedFromTest, Map<String, Object> parameters, Map<String, Object> pathVariables) {
        this.request = request;
        this.response = response;
        this.requestedFromTest = requestedFromTest;
        this.parameters = parameters;
        this.pathVariables = pathVariables;
        this.apiInfo = MappingHandlerMapping.getMappingApiInfo(request);
    }

    public static RequestEntity empty() {
        return new RequestEntity();
    }

    public ApiInfo getApiInfo() {
        return this.apiInfo;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public boolean isRequestedFromTest() {
        return this.requestedFromTest;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public Map<String, Object> getPathVariables() {
        return this.pathVariables;
    }

    public Long getRequestTime() {
        return this.requestTime;
    }

    public MagicScriptContext getMagicScriptContext() {
        return this.magicScriptContext;
    }

    public void setMagicScriptContext(MagicScriptContext magicScriptContext) {
        this.magicScriptContext = magicScriptContext;
    }

    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, Object> headers) {
        this.headers = headers;
    }
}

