/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.modules.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.ssssssss.magicapi.modules.table.NamedTable;
import org.ssssssss.script.annotation.Comment;
import org.ssssssss.script.functions.StreamExtension;

public class Where {
    private final List<String> tokens = new ArrayList<String>();
    private final List<Object> params = new ArrayList<Object>();
    private final NamedTable namedTable;
    private final boolean needWhere;

    public Where(NamedTable namedTable) {
        this(namedTable, true);
    }

    public Where(NamedTable namedTable, boolean needWhere) {
        this.namedTable = namedTable;
        this.needWhere = needWhere;
    }

    void appendAnd() {
        this.remove();
        this.tokens.add("and");
    }

    void appendOr() {
        this.remove();
        this.tokens.add("or");
    }

    List<Object> getParams() {
        return this.params;
    }

    void remove() {
        String token;
        int size;
        for (size = this.tokens.size(); size > 0 && ("and".equalsIgnoreCase(token = this.tokens.get(size - 1)) || "or".equalsIgnoreCase(token)); --size) {
            this.tokens.remove(size - 1);
        }
        while (size > 0 && ("and".equalsIgnoreCase(token = this.tokens.get(0)) || "or".equalsIgnoreCase(token))) {
            this.tokens.remove(0);
            --size;
        }
    }

    boolean isEmpty() {
        return this.tokens.isEmpty();
    }

    void append(String value) {
        this.tokens.add(value);
    }

    String getSql() {
        this.remove();
        if (this.isEmpty()) {
            return "";
        }
        return (this.needWhere ? " where " : "") + StringUtils.join(this.tokens, (String)" ");
    }

    @Comment(value="\u7b49\u4e8e`=`,\u5982\uff1a`eq('name', '\u8001\u738b') ---> name = '\u8001\u738b'`")
    public Where eq(@Comment(value="\u6570\u636e\u5e93\u4e2d\u7684\u5217\u540d") String column, @Comment(value="\u503c") Object value) {
        return this.eq(true, column, value);
    }

    @Comment(value="\u7b49\u4e8e`=`,\u5982\uff1a`eq('name', '\u8001\u738b') ---> name = '\u8001\u738b'`")
    public Where eq(@Comment(value="\u5224\u65ad\u8868\u8fbe\u5f0f\uff0c\u5f53\u4e3atrue\u65f6\u62fc\u63a5\u6761\u4ef6") boolean condition, @Comment(value="\u6570\u636e\u5e93\u4e2d\u7684\u5217\u540d") String column, @Comment(value="\u503c") Object value) {
        if (condition) {
            this.tokens.add(column);
            if (value == null) {
                this.append(" is null");
            } else {
                this.params.add(value);
                this.append(" = ?");
            }
            this.appendAnd();
        }
        return this;
    }

    @Comment(value="\u4e0d\u7b49\u4e8e`<>`,\u5982\uff1a`ne('name', '\u8001\u738b') ---> name <> '\u8001\u738b'`")
    public Where ne(@Comment(value="\u6570\u636e\u5e93\u4e2d\u7684\u5217\u540d") String column, @Comment(value="\u503c") Object value) {
        return this.ne(true, column, value);
    }

    @Comment(value="\u4e0d\u7b49\u4e8e`<>`,\u5982\uff1a`ne('name', '\u8001\u738b') ---> name <> '\u8001\u738b'`")
    public Where ne(@Comment(value="\u5224\u65ad\u8868\u8fbe\u5f0f\uff0c\u5f53\u4e3atrue\u65f6\u62fc\u63a5\u6761\u4ef6") boolean condition, @Comment(value="\u6570\u636e\u5e93\u4e2d\u7684\u5217\u540d") String column, @Comment(value="\u503c") Object value) {
        if (condition) {
            this.append(column);
            if (value == null) {
                this.append("is not null");
            } else {
                this.params.add(value);
                this.append("<> ?");
            }
            this.appendAnd();
        }
        return this;
    }

    private Where append(boolean append, String column, String condition, Object value) {
        if (append) {
            this.append(column);
            this.append(condition);
            this.appendAnd();
            this.params.add(value);
        }
        return this;
    }

    @Comment(value="\u5c0f\u4e8e`<`,\u5982\uff1a`lt('age', 18) ---> age < 18")
    public Where lt(@Comment(value="\u6570\u636e\u5e93\u4e2d\u7684\u5217\u540d") String column, @Comment(value="\u503c") Object value) {
        return this.lt(true, column, value);
    }

    @Comment(value="\u5c0f\u4e8e`<`,\u5982\uff1a`lt('age', 18) ---> age < 18")
    public Where lt(@Comment(value="\u5224\u65ad\u8868\u8fbe\u5f0f\uff0c\u5f53\u4e3atrue\u65f6\u62fc\u63a5\u6761\u4ef6") boolean condition, @Comment(value="\u6570\u636e\u5e93\u4e2d\u7684\u5217\u540d") String column, @Comment(value="\u503c") Object value) {
        return this.append(condition, column, " < ?", value);
    }

    @Comment(value="\u5c0f\u4e8e\u7b49\u4e8e`<=`,\u5982\uff1a`lte('age', 18) ---> age <= 18")
    public Where lte(@Comment(value="\u6570\u636e\u5e93\u4e2d\u7684\u5217\u540d") String column, @Comment(value="\u503c") Object value) {
        return this.lte(true, column, value);
    }

    @Comment(value="\u5c0f\u4e8e\u7b49\u4e8e`<=`,\u5982\uff1a`lte('age', 18) ---> age <= 18")
    public Where lte(@Comment(value="\u5224\u65ad\u8868\u8fbe\u5f0f\uff0c\u5f53\u4e3atrue\u65f6\u62fc\u63a5\u6761\u4ef6") boolean condition, @Comment(value="\u6570\u636e\u5e93\u4e2d\u7684\u5217\u540d") String column, @Comment(value="\u503c") Object value) {
        return this.append(condition, column, " <= ?", value);
    }

    @Comment(value="\u5927\u4e8e`>`,\u5982\uff1a`get('age', 18) ---> age > 18")
    public Where gt(@Comment(value="\u6570\u636e\u5e93\u4e2d\u7684\u5217\u540d") String column, @Comment(value="\u503c") Object value) {
        return this.gt(true, column, value);
    }

    @Comment(value="\u5927\u4e8e`>`,\u5982\uff1a`get('age', 18) ---> age > 18")
    public Where gt(@Comment(value="\u5224\u65ad\u8868\u8fbe\u5f0f\uff0c\u5f53\u4e3atrue\u65f6\u62fc\u63a5\u6761\u4ef6") boolean condition, @Comment(value="\u6570\u636e\u5e93\u4e2d\u7684\u5217\u540d") String column, @Comment(value="\u503c") Object value) {
        return this.append(condition, column, " > ?", value);
    }

    @Comment(value="\u5927\u4e8e\u7b49\u4e8e`>=`,\u5982\uff1a`get('age', 18) ---> age >= 18")
    public Where gte(@Comment(value="\u6570\u636e\u5e93\u4e2d\u7684\u5217\u540d") String column, @Comment(value="\u503c") Object value) {
        return this.gte(true, column, value);
    }

    @Comment(value="\u5927\u4e8e\u7b49\u4e8e`>=`,\u5982\uff1a`get('age', 18) ---> age >= 18")
    public Where gte(@Comment(value="\u5224\u65ad\u8868\u8fbe\u5f0f\uff0c\u5f53\u4e3atrue\u65f6\u62fc\u63a5\u6761\u4ef6") boolean condition, @Comment(value="\u6570\u636e\u5e93\u4e2d\u7684\u5217\u540d") String column, @Comment(value="\u503c") Object value) {
        return this.append(condition, column, " >= ?", value);
    }

    @Comment(value="`in`,\u5982\uff1a`in('age', [1,2,3]) ---> age in (1,2,3)")
    public Where in(@Comment(value="\u6570\u636e\u5e93\u4e2d\u7684\u5217\u540d") String column, @Comment(value="\u503c") Object value) {
        return this.in(true, column, value);
    }

    @Comment(value="`in`,\u5982\uff1a`in('age', [1,2,3]) ---> age in (1,2,3)")
    public Where in(@Comment(value="\u5224\u65ad\u8868\u8fbe\u5f0f\uff0c\u5f53\u4e3atrue\u65f6\u62fc\u63a5\u6761\u4ef6") boolean condition, @Comment(value="\u6570\u636e\u5e93\u4e2d\u7684\u5217\u540d") String column, @Comment(value="\u503c") Object value) {
        List objects;
        if (condition && value != null && (objects = StreamExtension.arrayLikeToList((Object)value)).size() > 0) {
            this.append(column);
            this.append(" in (");
            this.append(StringUtils.join((Object[])new Object[]{",", Collections.nCopies(objects.size(), "?")}));
            this.append(")");
            this.appendAnd();
            this.params.addAll(objects);
        }
        return this;
    }

    @Comment(value="`not in`,\u5982\uff1a`notIn('age', [1,2,3]) ---> age not in (1,2,3)")
    public Where notIn(@Comment(value="\u6570\u636e\u5e93\u4e2d\u7684\u5217\u540d") String column, @Comment(value="\u503c") Object value) {
        return this.notIn(true, column, value);
    }

    @Comment(value="`not in`,\u5982\uff1a`notIn('age', [1,2,3]) ---> age not in (1,2,3)")
    public Where notIn(@Comment(value="\u5224\u65ad\u8868\u8fbe\u5f0f\uff0c\u5f53\u4e3atrue\u65f6\u62fc\u63a5\u6761\u4ef6") boolean condition, @Comment(value="\u6570\u636e\u5e93\u4e2d\u7684\u5217\u540d") String column, @Comment(value="\u503c") Object value) {
        List objects;
        if (condition && value != null && (objects = StreamExtension.arrayLikeToList((Object)value)).size() > 0) {
            this.append(column);
            this.append("not in (");
            this.append(StringUtils.join((Object[])new Object[]{",", Collections.nCopies(objects.size(), "?")}));
            this.append(")");
            this.appendAnd();
            this.params.addAll(objects);
        }
        return this;
    }

    @Comment(value="`like`,\u5982\uff1a`like('name', '%\u738b%') ---> name like '%\u738b%'")
    public Where like(@Comment(value="\u6570\u636e\u5e93\u4e2d\u7684\u5217\u540d") String column, @Comment(value="\u503c") Object value) {
        return this.like(true, column, value);
    }

    @Comment(value="`like`,\u5982\uff1a`like('name', '%\u738b%') ---> name like '%\u738b%'")
    public Where like(@Comment(value="\u5224\u65ad\u8868\u8fbe\u5f0f\uff0c\u5f53\u4e3atrue\u65f6\u62fc\u63a5\u6761\u4ef6") boolean condition, @Comment(value="\u6570\u636e\u5e93\u4e2d\u7684\u5217\u540d") String column, @Comment(value="\u503c") Object value) {
        return this.append(condition, column, "like ?", value);
    }

    @Comment(value="`not like`,\u5982\uff1a`notLike('name', '%\u738b%') ---> name not like '%\u738b%'")
    public Where notLike(@Comment(value="\u6570\u636e\u5e93\u4e2d\u7684\u5217\u540d") String column, @Comment(value="\u503c") Object value) {
        return this.notLike(true, column, value);
    }

    @Comment(value="`not like` ,\u5982\uff1a`notLike('name', '%\u738b%') ---> name not like '%\u738b%'")
    public Where notLike(@Comment(value="\u5224\u65ad\u8868\u8fbe\u5f0f\uff0c\u5f53\u4e3atrue\u65f6\u62fc\u63a5\u6761\u4ef6") boolean condition, @Comment(value="\u6570\u636e\u5e93\u4e2d\u7684\u5217\u540d") String column, @Comment(value="\u503c") Object value) {
        return this.append(condition, column, "not like ?", value);
    }

    @Comment(value="`is null`,\u5982\uff1a`isNull('name') ---> name is null")
    public Where isNull(@Comment(value="\u6570\u636e\u5e93\u4e2d\u7684\u5217\u540d") String column) {
        return this.isNull(true, column);
    }

    @Comment(value="`is null`,\u5982\uff1a`isNull('name') ---> name is null")
    public Where isNull(@Comment(value="\u5224\u65ad\u8868\u8fbe\u5f0f\uff0c\u5f53\u4e3atrue\u65f6\u62fc\u63a5\u6761\u4ef6") boolean condition, @Comment(value="\u6570\u636e\u5e93\u4e2d\u7684\u5217\u540d") String column) {
        if (condition) {
            this.append(column);
            this.append("is null");
            this.appendAnd();
        }
        return this;
    }

    @Comment(value="`is not null`,\u5982\uff1a`isNotNull('name') ---> name is not null")
    public Where isNotNull(@Comment(value="\u6570\u636e\u5e93\u4e2d\u7684\u5217\u540d") String column) {
        return this.isNotNull(true, column);
    }

    @Comment(value="`is not null`,\u5982\uff1a`isNotNull('name') ---> name is not null")
    public Where isNotNull(@Comment(value="\u5224\u65ad\u8868\u8fbe\u5f0f\uff0c\u5f53\u4e3atrue\u65f6\u62fc\u63a5\u6761\u4ef6") boolean condition, @Comment(value="\u6570\u636e\u5e93\u4e2d\u7684\u5217\u540d") String column) {
        if (condition) {
            this.append(column);
            this.append("is not null");
            this.appendAnd();
        }
        return this;
    }

    @Comment(value="\u62fc\u63a5`or`")
    public Where or() {
        this.appendOr();
        return this;
    }

    @Comment(value="\u62fc\u63a5`and`")
    public Where and() {
        this.appendAnd();
        return this;
    }

    @Comment(value="`and`\u5d4c\u5957\uff0c\u5982and(it => it.eq('name','\u674e\u767d').ne('status','\u6b63\u5e38') --> and (name = '\u674e\u767d' and status <> '\u6b63\u5e38')")
    public Where and(Function<Object[], Where> function) {
        return this.and(true, function);
    }

    @Comment(value="`and`\u5d4c\u5957\uff0c\u5982and(it => it.eq('name','\u674e\u767d').ne('status','\u6b63\u5e38') --> and (name = '\u674e\u767d' and status <> '\u6b63\u5e38')")
    public Where and(@Comment(value="\u5224\u65ad\u8868\u8fbe\u5f0f\uff0c\u5f53\u4e3atrue\u65f6\u62fc\u63a5\u6761\u4ef6") boolean condition, Function<Object[], Where> function) {
        if (condition) {
            Where expr = function.apply(new Object[]{new Where(this.namedTable, false)});
            this.params.addAll(expr.params);
            this.append("(");
            this.append(expr.getSql());
            this.append(")");
            this.appendAnd();
        }
        return this;
    }

    @Comment(value="\u4fdd\u5b58\u5230\u8868\u4e2d\uff0c\u5f53\u4e3b\u952e\u6709\u503c\u65f6\u5219\u4fee\u6539\uff0c\u5426\u5219\u63d2\u5165")
    public int save() {
        return this.namedTable.save();
    }

    @Comment(value="\u4fdd\u5b58\u5230\u8868\u4e2d\uff0c\u5f53\u4e3b\u952e\u6709\u503c\u65f6\u5219\u4fee\u6539\uff0c\u5426\u5219\u63d2\u5165")
    public int save(@Comment(value="\u5404\u9879\u5217\u548c\u503c") Map<String, Object> data) {
        return this.namedTable.save(data);
    }

    @Comment(value="\u6267\u884c\u63d2\u5165\u8bed\u53e5")
    public int insert() {
        return this.namedTable.insert();
    }

    @Comment(value="\u6267\u884c\u63d2\u5165\u8bed\u53e5")
    public int insert(@Comment(value="\u5404\u9879\u5217\u548c\u503c") Map<String, Object> data) {
        return this.namedTable.insert(data);
    }

    @Comment(value="\u6267\u884cupdate\u8bed\u53e5")
    public int update() {
        return this.namedTable.update();
    }

    @Comment(value="\u6267\u884cupdate\u8bed\u53e5")
    public int update(@Comment(value="\u5404\u9879\u5217\u548c\u503c") Map<String, Object> data) {
        return this.namedTable.update(data);
    }

    @Comment(value="\u6267\u884c\u5206\u9875\u67e5\u8be2")
    public Object page() {
        return this.namedTable.page();
    }

    @Comment(value="\u6267\u884cselect\u67e5\u8be2")
    public List<Map<String, Object>> select() {
        return this.namedTable.select();
    }

    @Comment(value="\u6267\u884cselectOne\u67e5\u8be2")
    public Map<String, Object> selectOne() {
        return this.namedTable.selectOne();
    }
}

