/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.provider;

import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ssssssss.magicapi.adapter.Resource;
import org.ssssssss.magicapi.model.MagicEntity;
import org.ssssssss.magicapi.provider.GroupServiceProvider;
import org.ssssssss.magicapi.utils.JsonUtils;

public abstract class StoreServiceProvider<T extends MagicEntity> {
    String separatorWithCRLF = "\r\n================================\r\n";
    String separatorWithLF = "\n================================\n";
    protected Resource workspace;
    protected Resource backupResource;
    protected Map<String, Resource> mappings = new HashMap<String, Resource>();
    protected Map<String, T> infos = new HashMap<String, T>();
    protected GroupServiceProvider groupServiceProvider;
    protected Class<T> clazz;
    private static Logger logger = LoggerFactory.getLogger(StoreServiceProvider.class);

    public StoreServiceProvider(Class<T> clazz, Resource workspace, GroupServiceProvider groupServiceProvider) {
        this.clazz = clazz;
        this.workspace = workspace;
        this.groupServiceProvider = groupServiceProvider;
        if (!this.workspace.exists()) {
            this.workspace.mkdir();
        }
        this.backupResource = this.workspace.parent().getDirectory("backups");
        if (!this.backupResource.exists()) {
            this.backupResource.mkdir();
        }
    }

    public boolean insert(T info) {
        ((MagicEntity)info).setId(UUID.randomUUID().toString().replace("-", ""));
        ((MagicEntity)info).setUpdateTime(System.currentTimeMillis());
        ((MagicEntity)info).setCreateTime(((MagicEntity)info).getUpdateTime());
        Resource dest = this.groupServiceProvider.getGroupResource(((MagicEntity)info).getGroupId()).getResource(((MagicEntity)info).getName() + ".ms");
        if (!dest.exists() && dest.write(this.serialize(info))) {
            this.mappings.put(((MagicEntity)info).getId(), dest);
            this.infos.put(((MagicEntity)info).getId(), info);
            return true;
        }
        return false;
    }

    public boolean backup(T info) {
        Resource directory = this.backupResource.getDirectory(((MagicEntity)info).getId());
        if (!directory.readonly() && (directory.exists() || directory.mkdir())) {
            Resource resource = directory.getResource(String.format("%s.ms", System.currentTimeMillis()));
            try {
                return resource.write(this.serialize(info));
            }
            catch (Exception e) {
                logger.warn("\u4fdd\u5b58\u5386\u53f2\u8bb0\u5f55\u5931\u8d25,{}", (Object)e.getMessage());
            }
        }
        return false;
    }

    public List<Long> backupList(String id) {
        Resource directory = this.backupResource.getDirectory(id);
        List<Resource> resources = directory.files(".ms");
        return resources.stream().map(it -> Long.valueOf(it.name().replace(".ms", ""))).sorted(Comparator.reverseOrder()).collect(Collectors.toList());
    }

    public T backupInfo(String id, Long timestamp) {
        Resource resource;
        Resource directory = this.backupResource.getDirectory(id);
        if (directory.exists() && (resource = directory.getResource(String.format("%s.ms", timestamp))).exists()) {
            return this.deserialize(resource.read());
        }
        return null;
    }

    public boolean update(T info) {
        Resource dest = this.groupServiceProvider.getGroupResource(((MagicEntity)info).getGroupId()).getResource(((MagicEntity)info).getName() + ".ms");
        Resource src = this.mappings.get(((MagicEntity)info).getId());
        if (!src.name().equals(dest.name())) {
            if (dest.exists()) {
                return false;
            }
            src.renameTo(dest);
        }
        if (dest.write(this.serialize(info))) {
            this.mappings.put(((MagicEntity)info).getId(), dest);
            this.infos.put(((MagicEntity)info).getId(), info);
            return true;
        }
        return false;
    }

    public boolean delete(String id) {
        Resource resource = this.mappings.get(id);
        if (resource != null && resource.delete()) {
            this.mappings.remove(id);
            this.infos.remove(id);
            return true;
        }
        return false;
    }

    public List<T> list() {
        List<MagicEntity> infos = this.listWithScript();
        infos.forEach(info -> info.setScript(null));
        return infos;
    }

    public List<T> listWithScript() {
        this.workspace.readAll();
        List<Resource> resources = this.workspace.files(".ms");
        HashMap<String, Resource> mappings = new HashMap<String, Resource>();
        HashMap<String, T> infos = new HashMap<String, T>();
        List result = resources.stream().map(r -> {
            T info = this.deserialize(r.read());
            infos.put(((MagicEntity)info).getId(), info);
            mappings.put(((MagicEntity)info).getId(), (Resource)r);
            return ((MagicEntity)info).clone();
        }).collect(Collectors.toList());
        this.mappings = mappings;
        this.infos = infos;
        return result;
    }

    public T get(String id) {
        return (T)((MagicEntity)this.infos.get(id));
    }

    public boolean allowMove(String id, String groupId) {
        Resource resource = this.mappings.get(id);
        if (resource == null) {
            return false;
        }
        return !resource.readonly() && !this.groupServiceProvider.getGroupResource(groupId).getResource(resource.name()).exists();
    }

    public boolean move(String id, String groupId) {
        Resource dest = this.groupServiceProvider.getGroupResource(groupId);
        Resource src = this.mappings.get(id);
        if ((dest = dest.getResource(src.name())).exists()) {
            return false;
        }
        MagicEntity info = (MagicEntity)this.infos.get(id);
        src.renameTo(dest);
        info.setGroupId(groupId);
        this.mappings.put(id, dest);
        return dest.write(this.serialize(info));
    }

    public boolean deleteGroup(String rootId, List<String> groupIds) {
        if (!this.groupServiceProvider.getGroupResource(rootId).delete()) {
            return false;
        }
        for (String groupId : groupIds) {
            List<String> infoIds = this.infos.values().stream().filter(info -> groupId.equals(info.getGroupId())).map(MagicEntity::getId).collect(Collectors.toList());
            infoIds.forEach(this.infos::remove);
            infoIds.forEach(this.mappings::remove);
        }
        return true;
    }

    public void wrap(T info) {
    }

    public void unwrap(T info) {
    }

    public byte[] serialize(T info) {
        this.wrap(info);
        String script = ((MagicEntity)info).getScript();
        ((MagicEntity)info).setScript(null);
        String content = JsonUtils.toJsonString(info) + this.separatorWithCRLF + script;
        ((MagicEntity)info).setScript(script);
        this.unwrap(info);
        return content.getBytes(StandardCharsets.UTF_8);
    }

    public T deserialize(byte[] data) {
        String content = new String(data, StandardCharsets.UTF_8);
        String separator = this.separatorWithCRLF;
        int index = content.indexOf(separator);
        if (index == -1) {
            separator = this.separatorWithLF;
            index = content.indexOf(this.separatorWithLF);
        }
        if (index > -1) {
            MagicEntity info = (MagicEntity)JsonUtils.readValue(content.substring(0, index), this.clazz);
            info.setScript(content.substring(index + separator.length()));
            this.unwrap(info);
            return (T)info;
        }
        logger.warn("\u6587\u4ef6\u5185\u5bb9\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002");
        return null;
    }
}

