/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.provider.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.ssssssss.magicapi.adapter.Resource;
import org.ssssssss.magicapi.model.Group;
import org.ssssssss.magicapi.model.TreeNode;
import org.ssssssss.magicapi.provider.GroupServiceProvider;
import org.ssssssss.magicapi.utils.JsonUtils;
import org.ssssssss.magicapi.utils.PathUtils;

public class DefaultGroupServiceProvider
implements GroupServiceProvider {
    private Map<String, Group> cacheApiTree = new HashMap<String, Group>();
    private Map<String, Group> cacheFunctionTree = new HashMap<String, Group>();
    private final Map<String, Resource> mappings = new HashMap<String, Resource>();
    private final Resource workspace;
    private final String metabase = "group.json";

    public DefaultGroupServiceProvider(Resource workspace) {
        this.workspace = workspace;
    }

    @Override
    public boolean insert(Group group) {
        Resource resource;
        Resource directory;
        if (StringUtils.isBlank((CharSequence)group.getId())) {
            group.setId(UUID.randomUUID().toString().replace("-", ""));
        }
        Resource resource2 = directory = (directory = this.getGroupResource(group.getParentId())) == null ? this.getGroupResource(group.getType(), group.getName()) : directory.getDirectory(group.getName());
        if (!directory.exists() && directory.mkdir() && (resource = directory.getResource("group.json")).write(JsonUtils.toJsonString(group))) {
            this.mappings.put(group.getId(), resource);
            return true;
        }
        return false;
    }

    private Resource getGroupResource(String type, String name) {
        return this.workspace.getDirectory("1".equals(type) ? "api" : "function").getDirectory(name);
    }

    @Override
    public boolean update(Group group) {
        Resource target;
        Resource oldResource = this.getGroupResource(group.getId());
        Resource newResource = this.getGroupResource(group.getParentId());
        Resource resource = newResource = newResource == null ? this.getGroupResource(group.getType(), group.getName()) : newResource.getDirectory(group.getName());
        if (oldResource.renameTo(newResource) && (target = newResource.getResource("group.json")).write(JsonUtils.toJsonString(group))) {
            this.mappings.put(group.getId(), target);
            return true;
        }
        return false;
    }

    @Override
    public boolean delete(String groupId) {
        this.mappings.remove(groupId);
        return true;
    }

    @Override
    public boolean exists(Group group) {
        Resource resource = this.getGroupResource(group.getParentId());
        if (resource == null) {
            return this.getGroupResource(group.getType(), group.getName()).exists();
        }
        return resource.getDirectory(group.getName()).exists();
    }

    @Override
    public boolean containsApiGroup(String groupId) {
        return "0".equals(groupId) || this.cacheApiTree.containsKey(groupId);
    }

    @Override
    public Group readGroup(Resource resource) {
        return JsonUtils.readValue(resource.read(), Group.class);
    }

    @Override
    public TreeNode<Group> apiGroupTree() {
        List<Group> groups = this.groupList("1");
        this.cacheApiTree = groups.stream().collect(Collectors.toMap(Group::getId, value -> value));
        return this.convertToTree(groups);
    }

    @Override
    public TreeNode<Group> functionGroupTree() {
        List<Group> groups = this.groupList("2");
        this.cacheFunctionTree = groups.stream().collect(Collectors.toMap(Group::getId, value -> value));
        return this.convertToTree(groups);
    }

    @Override
    public List<Group> groupList(String type) {
        Resource resource = this.workspace.getDirectory("1".equals(type) ? "api" : "function");
        resource.readAll();
        return resource.dirs().stream().map(it -> it.getResource("group.json")).filter(Resource::exists).map(it -> {
            Group group = JsonUtils.readValue(it.read(), Group.class);
            this.mappings.put(group.getId(), (Resource)it);
            return group;
        }).collect(Collectors.toList());
    }

    @Override
    public String getFullPath(String groupId) {
        Group group;
        StringBuilder path = new StringBuilder();
        while ((group = this.cacheFunctionTree.getOrDefault(groupId, this.cacheApiTree.get(groupId))) != null) {
            path.insert(0, '/' + Objects.toString(group.getPath(), ""));
            groupId = group.getParentId();
        }
        if (!"0".equals(groupId)) {
            return null;
        }
        return PathUtils.replaceSlash(path.toString());
    }

    @Override
    public String getFullName(String groupId) {
        Group group;
        if (groupId == null || "0".equals(groupId)) {
            return "";
        }
        StringBuilder name = new StringBuilder();
        while ((group = this.cacheFunctionTree.getOrDefault(groupId, this.cacheApiTree.get(groupId))) != null) {
            name.insert(0, '/' + group.getName());
            groupId = group.getParentId();
        }
        if (!"0".equals(groupId)) {
            return null;
        }
        return name.substring(1);
    }

    @Override
    public Resource getGroupResource(String groupId) {
        if (groupId == null || "0".equals(groupId)) {
            return null;
        }
        Resource resource = this.mappings.get(groupId);
        return resource == null ? null : resource.parent();
    }

    private TreeNode<Group> convertToTree(List<Group> groups) {
        TreeNode<Group> root = new TreeNode<Group>();
        root.setNode(new Group("0", "root"));
        this.convertToTree(groups, root);
        return root;
    }

    private void convertToTree(List<Group> remains, TreeNode<Group> current) {
        LinkedList<TreeNode<TreeNode>> childNodes = new LinkedList<TreeNode<TreeNode>>();
        Iterator<Group> iterator = remains.iterator();
        while (iterator.hasNext()) {
            Group temp = iterator.next();
            if (!current.getNode().getId().equals(temp.getParentId())) continue;
            childNodes.add(new TreeNode<Group>(temp));
            iterator.remove();
        }
        current.setChildren(childNodes);
        childNodes.forEach(it -> this.convertToTree(remains, (TreeNode<Group>)it));
    }
}

