/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.provider.impl;

import java.util.Map;
import javax.script.ScriptContext;
import javax.script.SimpleScriptContext;
import org.ssssssss.magicapi.config.MappingHandlerMapping;
import org.ssssssss.magicapi.exception.MagicServiceException;
import org.ssssssss.magicapi.model.ApiInfo;
import org.ssssssss.magicapi.model.RequestEntity;
import org.ssssssss.magicapi.provider.MagicAPIService;
import org.ssssssss.magicapi.provider.ResultProvider;
import org.ssssssss.magicapi.script.ScriptManager;
import org.ssssssss.script.MagicResourceLoader;
import org.ssssssss.script.MagicScript;
import org.ssssssss.script.MagicScriptContext;
import org.ssssssss.script.parsing.Scope;
import org.ssssssss.script.parsing.Span;
import org.ssssssss.script.parsing.ast.Expression;

public class DefaultMagicAPIService
implements MagicAPIService {
    private final MappingHandlerMapping mappingHandlerMapping;
    private final boolean throwException;
    private final ResultProvider resultProvider;

    public DefaultMagicAPIService(MappingHandlerMapping mappingHandlerMapping, ResultProvider resultProvider, boolean throwException) {
        this.mappingHandlerMapping = mappingHandlerMapping;
        this.resultProvider = resultProvider;
        this.throwException = throwException;
        MagicResourceLoader.addFunctionLoader(name -> {
            String path;
            String method;
            ApiInfo info;
            int index = name.indexOf(":");
            if (index > -1 && (info = this.mappingHandlerMapping.getApiInfo(method = name.substring(0, index), path = name.substring(index + 1))) != null) {
                return new Expression(new Span("unknown source")){

                    public Object evaluate(MagicScriptContext context, Scope scope) {
                        return DefaultMagicAPIService.this.execute(info, scope.getVariables());
                    }
                };
            }
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object execute(ApiInfo info, Map<String, Object> context) {
        Object evalVal;
        MagicScriptContext magicScriptContext = MagicScriptContext.get();
        MagicScriptContext scriptContext = new MagicScriptContext();
        scriptContext.putMapIntoContext(context);
        SimpleScriptContext simpleScriptContext = new SimpleScriptContext();
        simpleScriptContext.setAttribute("ROOT", scriptContext, 100);
        try {
            evalVal = ((MagicScript)ScriptManager.compile("MagicScript", info.getScript())).eval((ScriptContext)simpleScriptContext);
        }
        finally {
            MagicScriptContext.set((MagicScriptContext)magicScriptContext);
        }
        return evalVal;
    }

    @Override
    public Object execute(String method, String path, Map<String, Object> context) {
        ApiInfo info = this.mappingHandlerMapping.getApiInfo(method, path);
        if (info == null) {
            throw new MagicServiceException(String.format("\u627e\u4e0d\u5230\u5bf9\u5e94\u63a5\u53e3 [%s:%s]", method, path));
        }
        return this.execute(info, context);
    }

    @Override
    public Object call(String method, String path, Map<String, Object> context) {
        RequestEntity requestEntity = RequestEntity.empty();
        try {
            return this.resultProvider.buildResult(requestEntity, this.execute(method, path, context));
        }
        catch (MagicServiceException e) {
            return null;
        }
        catch (Throwable root) {
            if (this.throwException) {
                throw root;
            }
            return this.resultProvider.buildResult(requestEntity, root);
        }
    }

    @Override
    public String getModuleName() {
        return "magic";
    }
}

