/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.script;

import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import org.ssssssss.magicapi.cache.DefaultSqlCache;
import org.ssssssss.magicapi.exception.MagicAPIException;
import org.ssssssss.magicapi.script.UnCompileScript;
import org.ssssssss.magicapi.utils.MD5Utils;
import org.ssssssss.script.MagicScriptContext;

public class ScriptManager {
    private static final ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
    private static final DefaultSqlCache compileCache = new DefaultSqlCache(500, -1L);

    public static CompiledScript compile(String engine, String script) {
        ScriptEngine scriptEngine;
        String key = MD5Utils.encrypt(script);
        CompiledScript scriptObject = (CompiledScript)compileCache.get("default", key);
        if (scriptObject == null && (scriptEngine = scriptEngineManager.getEngineByName(engine)) != null) {
            if (scriptEngine instanceof Compilable) {
                Compilable compilable = (Compilable)((Object)scriptEngine);
                try {
                    scriptObject = compilable.compile(script);
                }
                catch (Exception e) {
                    throw new MagicAPIException(String.format("\u7f16\u8bd1%s\u51fa\u9519", engine), e);
                }
            } else {
                scriptObject = new UnCompileScript(script, scriptEngine);
            }
            compileCache.put("default", key, scriptObject, -1L);
        }
        return scriptObject;
    }

    public static Object executeScript(String script, MagicScriptContext context) {
        SimpleScriptContext simpleScriptContext = new SimpleScriptContext();
        simpleScriptContext.setAttribute("ROOT", context, 100);
        try {
            return ScriptManager.compile("MagicScript", script).eval(simpleScriptContext);
        }
        catch (ScriptException e) {
            throw new MagicAPIException(e.getMessage(), e);
        }
    }

    public static Object executeExpression(String script, MagicScriptContext context) {
        return ScriptManager.executeScript("/* generated by execute expression */ return " + script, context);
    }
}

