/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtils {
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final Logger logger = LoggerFactory.getLogger(JsonUtils.class);

    public static String toJsonString(Object target) {
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(target);
        }
        catch (JsonProcessingException e) {
            logger.error("json\u5e8f\u5217\u5316\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public static <T> T readValue(String json, TypeReference<T> typeReference) {
        try {
            return (T)mapper.readValue(json, typeReference);
        }
        catch (IOException e) {
            logger.error("\u8bfb\u53d6json\u5931\u8d25,json:{}", (Object)json, (Object)e);
            return null;
        }
    }

    public static <T> T readValue(String json, Class<T> clazz) {
        try {
            return (T)mapper.readValue(json, clazz);
        }
        catch (IOException e) {
            logger.error("\u8bfb\u53d6json\u5931\u8d25,json:{}", (Object)json, (Object)e);
            return null;
        }
    }

    public static <T> T readValue(byte[] bytes, Class<T> clazz) {
        try {
            return (T)mapper.readValue(bytes, clazz);
        }
        catch (IOException e) {
            logger.error("\u8bfb\u53d6json\u5931\u8d25,json:{}", (Object)new String(bytes), (Object)e);
            return null;
        }
    }

    public static <T> T readValue(byte[] bytes, JavaType javaType) {
        try {
            return (T)mapper.readValue(bytes, javaType);
        }
        catch (IOException e) {
            logger.error("\u8bfb\u53d6json\u5931\u8d25,json:{}", (Object)new String(bytes), (Object)e);
            return null;
        }
    }

    static {
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

