/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.module.spec.internal;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.cglib.proxy.MethodProxy;
import org.test4j.module.spec.IStory;
import org.test4j.module.spec.StoryModuleListener;
import org.test4j.module.spec.annotations.Given;
import org.test4j.module.spec.annotations.Mix;
import org.test4j.module.spec.annotations.Mixes;
import org.test4j.module.spec.annotations.Step;
import org.test4j.module.spec.annotations.Then;
import org.test4j.module.spec.annotations.When;
import org.test4j.module.spec.internal.ScenarioResult;
import org.test4j.module.spring.SpringEnv;
import org.test4j.tools.commons.AnnotationHelper;
import org.test4j.tools.commons.ClazzHelper;
import org.test4j.tools.reflector.FieldAccessor;

public class MixProxy<T>
implements MethodInterceptor {
    private static final Set<String> Ignore_Methods = new HashSet<String>(){
        {
            this.add("toString");
            this.add("hashCode");
            this.add("setData");
            this.add("getData");
        }
    };
    private String klass;
    private boolean injected = false;
    private Lock lock = new ReentrantLock();

    private MixProxy(Class<T> klass) {
        this.klass = klass.getName();
    }

    public static <T> T proxy(Class<T> klass) {
        Enhancer enhancer = new Enhancer();
        enhancer.setCallback(new MixProxy<T>(klass));
        enhancer.setSuperclass(klass);
        enhancer.setInterfaces(new Class[]{Serializable.class});
        return (T)enhancer.create();
    }

    public static void mix(Object injectedObject) {
        MixProxy.mix(injectedObject, injectedObject.getClass());
    }

    private static void mix(Object injectedObject, Class<?> klass) {
        Set fields = AnnotationHelper.getFieldsAnnotatedWith(klass, Mix.class);
        if (fields == null) {
            return;
        }
        fields.forEach(field -> {
            Object mix = MixProxy.proxy(field.getType());
            FieldAccessor.field((Field)field).set(injectedObject, mix);
        });
    }

    public static void createMixes(Object testedObject) {
        Set fields = AnnotationHelper.getFieldsAnnotatedWith(testedObject.getClass(), Mixes.class);
        if (fields == null) {
            return;
        }
        fields.forEach(field -> {
            Object mixes = ClazzHelper.newInstance(field.getType());
            MixProxy.mix(mixes, field.getType());
            FieldAccessor.field((Field)field).set(testedObject, mixes);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object intercept(Object obj, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
        String methodKlass;
        String methodName = method.getName();
        if (this.isSkipMethod(methodName, methodKlass = method.getDeclaringClass().getName())) {
            return methodProxy.invokeSuper(obj, args);
        }
        if (!this.injected) {
            this.injectSpring(obj);
        }
        String name = this.klass + "#" + methodName;
        ScenarioResult scenario = StoryModuleListener.currScenario();
        if (scenario.isFailure()) {
            scenario.getLastStep().skip(name);
            return null;
        }
        String description = this.getMethodDescription(method, args);
        Object result = null;
        try {
            Object object = result = methodProxy.invokeSuper(obj, args);
            return object;
        }
        finally {
            try {
                scenario.getLastStep().setDescription(name, description, args, result);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    private boolean isSkipMethod(String method, String klass) {
        if (Ignore_Methods.contains(method)) {
            return true;
        }
        return IStory.class.getName().equals(klass);
    }

    private void injectSpring(Object obj) {
        this.lock.lock();
        try {
            if (this.injected) {
                return;
            }
            SpringEnv.injectSpringBeans((Object)obj);
        }
        finally {
            this.injected = true;
            this.lock.unlock();
        }
    }

    private String getMethodDescription(Method method, Object[] args) {
        Step step = method.getDeclaredAnnotation(Step.class);
        if (step != null) {
            return step.value();
        }
        Given given = method.getDeclaredAnnotation(Given.class);
        if (given != null) {
            return given.value();
        }
        When when = method.getDeclaredAnnotation(When.class);
        if (when != null) {
            return when.value();
        }
        Then then = method.getDeclaredAnnotation(Then.class);
        if (then != null) {
            return then.value();
        }
        return Arrays.stream(args).map(arg -> "{}").collect(Collectors.joining(", "));
    }
}

