/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.module.spec.internal;

import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.test4j.Logger;
import org.test4j.tools.commons.ResourceHelper;

public class StoryPrinter {
    private static ThreadLocal<List<ScenarioInfo>> CURR_SCENARIO_LIST = new ThreadLocal();
    private static File indexFile;

    public static String getStoryPath() {
        return System.getProperty("user.dir") + "/target/story/";
    }

    public static void print(String scenarioPath, String scenarioName, String scenarioResult, Throwable testThrowable) {
        Logger.info((Object)scenarioResult, (Throwable[])new Throwable[0]);
        String scenarioFile = scenarioPath + ".txt";
        try {
            ResourceHelper.writeStringToFile((File)new File(StoryPrinter.getStoryPath() + "scenario/" + scenarioFile), (String)scenarioResult);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (CURR_SCENARIO_LIST.get() == null) {
            CURR_SCENARIO_LIST.set(new ArrayList());
        }
        CURR_SCENARIO_LIST.get().add(new ScenarioInfo(scenarioName, scenarioFile, testThrowable == null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printScenarioIndex(String testKlassName) {
        StoryPrinter.initIndexFile();
        List<ScenarioInfo> scenarios = CURR_SCENARIO_LIST.get();
        if (scenarios == null) {
            return;
        }
        try (FileWriter writer = new FileWriter(indexFile, true);){
            writer.write("<li>\n");
            writer.write(String.format("<span class='badge %s'>%s</span>\n", ScenarioInfo.listStyle(scenarios), testKlassName));
            writer.write("<ul>\n");
            String context = scenarios.stream().map(StoryPrinter::printScenarioIndex).collect(Collectors.joining("\n"));
            writer.write(context);
            writer.write("</ul>\n");
            writer.write("</li>\n");
            writer.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            CURR_SCENARIO_LIST.get().clear();
        }
    }

    private static String printScenarioIndex(ScenarioInfo scenario) {
        return "<li>" + String.format("<a class='badge %s' href='javascript:doShow(\"%s\");'>", scenario.getStyle(), scenario.getScenarioPath()) + scenario.getScenarioName() + "</a>" + "</li>";
    }

    private static void initIndexFile() {
        if (indexFile != null) {
            return;
        }
        String scPath = StoryPrinter.getStoryPath() + "scenario/";
        try {
            indexFile = new File(StoryPrinter.getStoryPath() + "index.html");
            ResourceHelper.writeStringToFile((File)new File(StoryPrinter.getStoryPath() + "scenario/ok.html"), (String)"");
            ResourceHelper.copyClassPathResource((String)"scenario/jquery-3.4.1.min.js", (String)(scPath + "jquery-3.4.1.min.js"));
            ResourceHelper.copyClassPathResource((String)"scenario/story.js", (String)(scPath + "story.js"));
            ResourceHelper.copyClassPathResource((String)"scenario/story.css", (String)(scPath + "story.css"));
            ResourceHelper.copyClassPathResource((String)"scenario/bootstrap.min.css", (String)(scPath + "bootstrap.min.css"));
            ResourceHelper.copyClassPathResource((String)"scenario/index.html", (String)(StoryPrinter.getStoryPath() + "index.html"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class ScenarioInfo {
        String scenarioName;
        String scenarioPath;
        boolean isSuccess;

        public ScenarioInfo(String name, String path, boolean success) {
            this.scenarioName = name;
            this.scenarioPath = path;
            this.isSuccess = success;
        }

        public String getStyle() {
            return this.isSuccess ? "badge-success" : "badge-important";
        }

        public static String listStyle(List<ScenarioInfo> scenarios) {
            boolean hasSuccess = false;
            boolean hasFailure = false;
            for (ScenarioInfo scenario : scenarios) {
                if (scenario.isSuccess) {
                    hasSuccess = true;
                    continue;
                }
                hasFailure = true;
            }
            if (hasSuccess && hasFailure) {
                return "badge-warning";
            }
            if (hasSuccess) {
                return "badge-success";
            }
            return "badge-important";
        }

        public String getScenarioName() {
            return this.scenarioName;
        }

        public String getScenarioPath() {
            return this.scenarioPath;
        }

        public boolean isSuccess() {
            return this.isSuccess;
        }
    }
}

