/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.module.spec.internal;

import java.util.function.Consumer;
import org.test4j.exception.ExtraMessageError;
import org.test4j.module.database.IDatabase;
import org.test4j.module.database.datagen.TableMap;
import org.test4j.module.spec.internal.StepResult;
import org.test4j.tools.commons.ResourceHelper;
import org.test4j.tools.datagen.IDataMap;
import org.test4j.tools.json.JSON;

public class TableDataAround {
    private TableMap ready;
    private TableMap check;
    static ThreadLocal<TableDataAround> THREAD_LOCAL_AROUND = new ThreadLocal();

    public static TableDataAround around(String file) {
        THREAD_LOCAL_AROUND.remove();
        String text = ResourceHelper.readFromClasspath((String)file);
        TableDataAround around = (TableDataAround)JSON.toObject((String)text, TableDataAround.class);
        if (around.getReady() == null) {
            throw new RuntimeException("not found ready data in file:" + file);
        }
        if (around.getCheck() == null) {
            throw new RuntimeException("not found check data in file:" + file);
        }
        THREAD_LOCAL_AROUND.set(around);
        return around;
    }

    public static void ready(StepResult result) throws Throwable {
        if (THREAD_LOCAL_AROUND.get() == null || THREAD_LOCAL_AROUND.get().getReady() == null) {
            return;
        }
        try {
            TableMap tableMap = THREAD_LOCAL_AROUND.get().getReady();
            String extra = IDatabase.db.insert(tableMap, false);
            result.extraMessage(extra);
        }
        catch (ExtraMessageError e) {
            result.extraMessage(e.getExtra());
            throw e.getCause();
        }
    }

    public static void check(StepResult result) throws Throwable {
        if (THREAD_LOCAL_AROUND.get() == null || THREAD_LOCAL_AROUND.get().getCheck() == null) {
            return;
        }
        try {
            TableMap tableMap = THREAD_LOCAL_AROUND.get().getCheck();
            String extra = IDatabase.db.queryEq(tableMap);
            result.extraMessage(extra);
        }
        catch (ExtraMessageError e) {
            result.extraMessage(e.getExtra());
            throw e.getCause();
        }
    }

    public static void remove() {
        try {
            THREAD_LOCAL_AROUND.remove();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void initReady(Consumer<TableMap> handler) {
        if (THREAD_LOCAL_AROUND.get() == null || handler == null) {
            return;
        }
        handler.accept(THREAD_LOCAL_AROUND.get().getReady());
    }

    public static void initCheck(Consumer<TableMap> handler) {
        if (THREAD_LOCAL_AROUND.get() == null || handler == null) {
            return;
        }
        handler.accept(THREAD_LOCAL_AROUND.get().getCheck());
    }

    public static void initReady(IDataMap data, String ... tables) {
        if (THREAD_LOCAL_AROUND.get() == null || data == null) {
            return;
        }
        THREAD_LOCAL_AROUND.get().getReady().initWith(data, false, tables);
    }

    public static void initCheck(IDataMap data, String ... tables) {
        if (THREAD_LOCAL_AROUND.get() == null || data == null) {
            return;
        }
        THREAD_LOCAL_AROUND.get().getCheck().initWith(data, true, tables);
    }

    public static String findFile(Class klass, String method) {
        String path = klass.getName().replace('.', '/');
        String file1 = path + "/" + method + ".json";
        if (ClassLoader.getSystemResource(file1) != null) {
            return file1;
        }
        String file2 = path + "." + method + ".json";
        if (ClassLoader.getSystemResource(file2) != null) {
            return file2;
        }
        throw new RuntimeException(String.format("\n\tFile: %s \nor \tFile: %s \nnot found in classpath.", file1, file2));
    }

    public TableMap getReady() {
        return this.ready;
    }

    public TableMap getCheck() {
        return this.check;
    }

    public void setReady(TableMap ready) {
        this.ready = ready;
    }

    public void setCheck(TableMap check) {
        this.check = check;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableDataAround)) {
            return false;
        }
        TableDataAround other = (TableDataAround)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TableMap this$ready = this.getReady();
        TableMap other$ready = other.getReady();
        if (this$ready == null ? other$ready != null : !this$ready.equals(other$ready)) {
            return false;
        }
        TableMap this$check = this.getCheck();
        TableMap other$check = other.getCheck();
        return !(this$check == null ? other$check != null : !this$check.equals(other$check));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TableDataAround;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TableMap $ready = this.getReady();
        result = result * 59 + ($ready == null ? 43 : $ready.hashCode());
        TableMap $check = this.getCheck();
        result = result * 59 + ($check == null ? 43 : $check.hashCode());
        return result;
    }

    public String toString() {
        return "TableDataAround(ready=" + this.getReady() + ", check=" + this.getCheck() + ")";
    }
}

