/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.instrumentation;

import com.intellij.compiler.instrumentation.InstrumentationClassFinder;
import com.intellij.compiler.instrumentation.PseudoClass;
import org.objectweb.asm.ClassWriter;

public class InstrumenterClassWriter
extends ClassWriter {
    private final InstrumentationClassFinder myFinder;

    public InstrumenterClassWriter(int flags, InstrumentationClassFinder finder) {
        super(flags);
        this.myFinder = finder;
    }

    protected String getCommonSuperClass(String type1, String type2) {
        try {
            PseudoClass cls1 = this.myFinder.loadClass(type1);
            PseudoClass cls2 = this.myFinder.loadClass(type2);
            if (cls1.isAssignableFrom(cls2)) {
                return cls1.getName();
            }
            if (cls2.isAssignableFrom(cls1)) {
                return cls2.getName();
            }
            if (cls1.isInterface() || cls2.isInterface()) {
                return "java/lang/Object";
            }
            PseudoClass pseudoClass = cls1;
            while (!(pseudoClass = pseudoClass.getSuperClass()).isAssignableFrom(cls2)) {
            }
            return pseudoClass.getName();
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString(), e);
        }
    }
}

