/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.notNullVerification;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import se.eris.asm.AsmUtils;
import se.eris.lang.LangUtils;

public abstract class ThrowOnNullMethodVisitor
extends MethodVisitor {
    static final String LJAVA_LANG_SYNTHETIC_ANNO = "Ljava/lang/Synthetic;";
    private static final String IAE_CLASS_NAME = "java/lang/IllegalArgumentException";
    private static final String ISE_CLASS_NAME = "java/lang/IllegalStateException";
    private static final String CONSTRUCTOR_NAME = "<init>";
    protected ArrayList<String> parameterNames = null;
    final Type[] argumentTypes;
    private final Type returnType;
    boolean isReturnNotNull;
    private final boolean isAnonymousClass;
    private boolean instrumented = false;
    private int syntheticCount;
    final int access;
    final String methodName;
    final String className;
    final List<Integer> notNullParams;
    Label startGeneratedCodeLabel;

    ThrowOnNullMethodVisitor(int api, @Nullable MethodVisitor mv, @NotNull Type[] argumentTypes, Type returnType, int access, String methodName, String className, boolean isReturnNotNull, boolean isAnonymousClass) {
        super(api, mv);
        this.argumentTypes = argumentTypes;
        this.returnType = returnType;
        this.access = access;
        this.methodName = methodName;
        this.className = className;
        this.isReturnNotNull = isReturnNotNull;
        this.isAnonymousClass = isAnonymousClass;
        this.syntheticCount = 0;
        this.notNullParams = new ArrayList<Integer>();
    }

    private void setInstrumented() {
        this.instrumented = true;
    }

    public void visitParameter(String name, int access) {
        if (this.parameterNames == null) {
            this.parameterNames = new ArrayList(this.argumentTypes.length);
        }
        this.parameterNames.add(name);
        if (this.mv != null) {
            this.mv.visitParameter(name, access);
        }
    }

    public void visitInsn(int opcode) {
        if (this.shouldInclude() && opcode == 176 && this.isReturnNotNull) {
            this.mv.visitInsn(89);
            Label skipLabel = new Label();
            this.mv.visitJumpInsn(199, skipLabel);
            this.generateThrow(ISE_CLASS_NAME, "NotNull method " + this.className + "." + this.methodName + " must not return null", skipLabel);
        }
        this.mv.visitInsn(opcode);
    }

    boolean hasInstrumented() {
        return this.instrumented;
    }

    private boolean isStatic() {
        return (this.access & 8) != 0;
    }

    boolean isParameter(int index) {
        return this.isStatic() ? index < this.argumentTypes.length : index <= this.argumentTypes.length;
    }

    public void visitCode() {
        if (this.shouldInclude()) {
            if (!this.notNullParams.isEmpty()) {
                this.startGeneratedCodeLabel = new Label();
                this.mv.visitLabel(this.startGeneratedCodeLabel);
            }
            for (Integer notNullParam : this.notNullParams) {
                int var = (this.access & 8) == 0 ? 1 : 0;
                for (int i = 0; i < notNullParam; ++i) {
                    var += this.argumentTypes[i].getSize();
                }
                this.mv.visitVarInsn(25, var);
                Label end = new Label();
                this.mv.visitJumpInsn(199, end);
                this.generateThrow(IAE_CLASS_NAME, this.getThrowMessage(notNullParam), end);
            }
        }
        this.mv.visitCode();
    }

    protected boolean shouldInclude() {
        return !this.shouldSkip();
    }

    private boolean shouldSkip() {
        return this.isSynthetic() || this.isAnonymousClassConstructor();
    }

    private boolean isAnonymousClassConstructor() {
        return this.isAnonymousClass && this.isConstructor();
    }

    private boolean isConstructor() {
        return CONSTRUCTOR_NAME.equals(this.methodName);
    }

    @Contract(pure=true)
    private boolean isSynthetic() {
        return (this.access & 0x1000) == 4096;
    }

    private void generateThrow(@NotNull String exceptionClass, @NotNull String description, @NotNull Label end) {
        String exceptionParamClass = "(" + LangUtils.convertToJavaClassName(String.class.getName()) + ")V";
        this.mv.visitTypeInsn(187, exceptionClass);
        this.mv.visitInsn(89);
        this.mv.visitLdcInsn((Object)description);
        this.mv.visitMethodInsn(183, exceptionClass, CONSTRUCTOR_NAME, exceptionParamClass, false);
        this.mv.visitInsn(191);
        this.mv.visitLabel(end);
        this.setInstrumented();
    }

    boolean isReturnReferenceType() {
        return AsmUtils.isReferenceType(this.returnType);
    }

    boolean isParameterReferenceType(int parameter) {
        return AsmUtils.isReferenceType(this.argumentTypes[parameter]);
    }

    @NotNull
    private String getThrowMessage(int parameterNumber) {
        int pnum = this.getSourceCodeParameterNumber(parameterNumber);
        String pname = this.parameterNames == null || this.parameterNames.size() <= pnum ? "" : String.format(" (parameter '%s')", this.parameterNames.get(pnum));
        return String.format("%s argument %d%s of %s.%s must not be null", this.notNullCause(), pnum, pname, this.className, this.methodName);
    }

    @NotNull
    protected abstract String notNullCause();

    int increaseSyntheticCount() {
        return this.syntheticCount++;
    }

    private int getSourceCodeParameterNumber(int parameterNumber) {
        return parameterNumber - this.syntheticCount;
    }
}

