/*
 * Decompiled with CFR 0.152.
 */
package se.eris.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ClassFileUtils {
    @NotNull
    public static Set<File> getClassFiles(@NotNull Path rootDir) {
        try {
            ClassFileCollector collector = new ClassFileCollector();
            Files.walkFileTree(rootDir, collector);
            return collector.getClassFiles();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not collect class files in directory '" + rootDir + "'", e);
        }
    }

    private static class ClassFileCollector
    extends SimpleFileVisitor<Path> {
        private static final String CLASS_FILE_EXTENSION = ".class";
        private final Set<File> classFiles = new HashSet<File>();

        private ClassFileCollector() {
        }

        @Override
        public FileVisitResult visitFile(@NotNull Path path, @NotNull BasicFileAttributes attrs) throws IOException {
            if (attrs.isRegularFile() && path.toFile().getName().endsWith(CLASS_FILE_EXTENSION)) {
                this.classFiles.add(path.toFile());
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(@NotNull Path file, @NotNull IOException exc) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        @NotNull
        private Set<File> getClassFiles() {
            return this.classFiles;
        }
    }
}

