/*
 * Decompiled with CFR 0.152.
 */
package tk.mybatis.mapper.provider.base;

import java.util.Set;
import org.apache.ibatis.mapping.MappedStatement;
import tk.mybatis.mapper.MapperException;
import tk.mybatis.mapper.entity.EntityColumn;
import tk.mybatis.mapper.mapperhelper.EntityHelper;
import tk.mybatis.mapper.mapperhelper.MapperHelper;
import tk.mybatis.mapper.mapperhelper.MapperTemplate;
import tk.mybatis.mapper.mapperhelper.SelectKeyHelper;
import tk.mybatis.mapper.mapperhelper.SqlHelper;
import tk.mybatis.mapper.util.StringUtil;

public class BaseInsertProvider
extends MapperTemplate {
    public BaseInsertProvider(Class<?> mapperClass, MapperHelper mapperHelper) {
        super(mapperClass, mapperHelper);
    }

    public String insert(MappedStatement ms) {
        Class<?> entityClass = this.getEntityClass(ms);
        StringBuilder sql = new StringBuilder();
        Set<EntityColumn> columnList = EntityHelper.getColumns(entityClass);
        Boolean hasIdentityKey = false;
        for (EntityColumn column : columnList) {
            if (!column.isInsertable() || StringUtil.isNotEmpty(column.getSequenceName())) continue;
            if (column.isIdentity()) {
                sql.append(SqlHelper.getBindCache(column));
                if (hasIdentityKey.booleanValue()) {
                    if (column.getGenerator() != null && column.getGenerator().equals("JDBC")) continue;
                    throw new MapperException(ms.getId() + "\u5bf9\u5e94\u7684\u5b9e\u4f53\u7c7b" + entityClass.getCanonicalName() + "\u4e2d\u5305\u542b\u591a\u4e2aMySql\u7684\u81ea\u52a8\u589e\u957f\u5217,\u6700\u591a\u53ea\u80fd\u6709\u4e00\u4e2a!");
                }
                SelectKeyHelper.newSelectKeyMappedStatement(ms, column, entityClass, this.isBEFORE(), this.getIDENTITY(column));
                hasIdentityKey = true;
                continue;
            }
            if (!column.isUuid()) continue;
            sql.append(SqlHelper.getBindValue(column, this.getUUID()));
        }
        sql.append(SqlHelper.insertIntoTable(entityClass, this.tableName(entityClass)));
        sql.append(SqlHelper.insertColumns(entityClass, false, false, false));
        sql.append("<trim prefix=\"VALUES(\" suffix=\")\" suffixOverrides=\",\">");
        for (EntityColumn column : columnList) {
            if (!column.isInsertable()) continue;
            if (column.isIdentity()) {
                sql.append(SqlHelper.getIfCacheNotNull(column, column.getColumnHolder(null, "_cache", ",")));
            } else {
                sql.append(SqlHelper.getIfNotNull(column, column.getColumnHolder(null, null, ","), this.isNotEmpty()));
            }
            if (StringUtil.isNotEmpty(column.getSequenceName())) {
                sql.append(SqlHelper.getIfIsNull(column, this.getSeqNextVal(column) + " ,", false));
                continue;
            }
            if (column.isIdentity()) {
                sql.append(SqlHelper.getIfCacheIsNull(column, column.getColumnHolder() + ","));
                continue;
            }
            if (column.isUuid()) {
                sql.append(SqlHelper.getIfIsNull(column, column.getColumnHolder(null, "_bind", ","), this.isNotEmpty()));
                continue;
            }
            sql.append(SqlHelper.getIfIsNull(column, column.getColumnHolder(null, null, ","), this.isNotEmpty()));
        }
        sql.append("</trim>");
        return sql.toString();
    }

    public String insertSelective(MappedStatement ms) {
        Class<?> entityClass = this.getEntityClass(ms);
        StringBuilder sql = new StringBuilder();
        Set<EntityColumn> columnList = EntityHelper.getColumns(entityClass);
        Boolean hasIdentityKey = false;
        for (EntityColumn column : columnList) {
            if (!column.isInsertable() || StringUtil.isNotEmpty(column.getSequenceName())) continue;
            if (column.isIdentity()) {
                sql.append(SqlHelper.getBindCache(column));
                if (hasIdentityKey.booleanValue()) {
                    if (column.getGenerator() != null && column.getGenerator().equals("JDBC")) continue;
                    throw new MapperException(ms.getId() + "\u5bf9\u5e94\u7684\u5b9e\u4f53\u7c7b" + entityClass.getCanonicalName() + "\u4e2d\u5305\u542b\u591a\u4e2aMySql\u7684\u81ea\u52a8\u589e\u957f\u5217,\u6700\u591a\u53ea\u80fd\u6709\u4e00\u4e2a!");
                }
                SelectKeyHelper.newSelectKeyMappedStatement(ms, column, entityClass, this.isBEFORE(), this.getIDENTITY(column));
                hasIdentityKey = true;
                continue;
            }
            if (!column.isUuid()) continue;
            sql.append(SqlHelper.getBindValue(column, this.getUUID()));
        }
        sql.append(SqlHelper.insertIntoTable(entityClass, this.tableName(entityClass)));
        sql.append("<trim prefix=\"(\" suffix=\")\" suffixOverrides=\",\">");
        for (EntityColumn column : columnList) {
            if (!column.isInsertable()) continue;
            if (StringUtil.isNotEmpty(column.getSequenceName()) || column.isIdentity() || column.isUuid()) {
                sql.append(column.getColumn() + ",");
                continue;
            }
            sql.append(SqlHelper.getIfNotNull(column, column.getColumn() + ",", this.isNotEmpty()));
        }
        sql.append("</trim>");
        sql.append("<trim prefix=\"VALUES(\" suffix=\")\" suffixOverrides=\",\">");
        for (EntityColumn column : columnList) {
            if (!column.isInsertable()) continue;
            if (column.isIdentity()) {
                sql.append(SqlHelper.getIfCacheNotNull(column, column.getColumnHolder(null, "_cache", ",")));
            } else {
                sql.append(SqlHelper.getIfNotNull(column, column.getColumnHolder(null, null, ","), this.isNotEmpty()));
            }
            if (StringUtil.isNotEmpty(column.getSequenceName())) {
                sql.append(SqlHelper.getIfIsNull(column, this.getSeqNextVal(column) + " ,", this.isNotEmpty()));
                continue;
            }
            if (column.isIdentity()) {
                sql.append(SqlHelper.getIfCacheIsNull(column, column.getColumnHolder() + ","));
                continue;
            }
            if (!column.isUuid()) continue;
            sql.append(SqlHelper.getIfIsNull(column, column.getColumnHolder(null, "_bind", ","), this.isNotEmpty()));
        }
        sql.append("</trim>");
        return sql.toString();
    }
}

