/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.monitor.vo;

import java.text.DecimalFormat;
import oshi.SystemInfo;
import oshi.hardware.GlobalMemory;
import xyz.erupt.monitor.util.SystemUtil;

public class Mem {
    private String total;
    private String used;
    private String free;
    private String usage;

    Mem(SystemInfo systemInfo) {
        GlobalMemory memory = systemInfo.getHardware().getMemory();
        long totalByte = memory.getTotal();
        long availableByte = memory.getAvailable();
        this.setTotal(SystemUtil.formatByte(totalByte));
        this.setUsed(SystemUtil.formatByte(totalByte - availableByte));
        this.setFree(SystemUtil.formatByte(availableByte));
        this.setUsage(new DecimalFormat("#.##%").format((double)(totalByte - availableByte) * 1.0 / (double)totalByte));
    }

    public String getTotal() {
        return this.total;
    }

    public String getUsed() {
        return this.used;
    }

    public String getFree() {
        return this.free;
    }

    public String getUsage() {
        return this.usage;
    }

    public void setTotal(String total) {
        this.total = total;
    }

    public void setUsed(String used) {
        this.used = used;
    }

    public void setFree(String free) {
        this.free = free;
    }

    public void setUsage(String usage) {
        this.usage = usage;
    }
}

