/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.monitor.vo.redis;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import xyz.erupt.monitor.vo.redis.RedisCmdStat;

public class RedisInfo {
    private String version;
    private String port;
    private String day;
    private String clientNum;
    private String totalMem;
    private String usedMem;
    private Long keyNum;
    private boolean isCluster;
    private boolean isAOF;
    private List<RedisCmdStat> redisCmdStat = new ArrayList<RedisCmdStat>();

    public RedisInfo(RedisConnectionFactory redisConnectionFactory) {
        RedisConnection redisConnection = redisConnectionFactory.getConnection();
        Properties properties = redisConnection.info();
        Properties commandStats = redisConnection.info("commandstats");
        if (null != commandStats) {
            commandStats.stringPropertyNames().forEach(key -> {
                String cs = "cmdstat_";
                if (key.startsWith(cs)) {
                    this.redisCmdStat.add(new RedisCmdStat(StringUtils.removeStart((String)key, (String)cs), StringUtils.substringBetween((String)commandStats.getProperty((String)key), (String)"calls=", (String)",usec")));
                }
            });
        }
        if (null != properties) {
            String aofEnabled;
            this.setKeyNum(redisConnectionFactory.getConnection().serverCommands().dbSize());
            this.setVersion(properties.getProperty("redis_version"));
            this.setUsedMem(properties.getProperty("used_memory_human"));
            if ("0".equals(properties.getProperty("maxmemory"))) {
                this.setTotalMem(properties.getProperty("total_system_memory_human"));
            } else {
                this.setTotalMem(properties.getProperty("maxmemory_human"));
            }
            this.setPort(properties.getProperty("tcp_port"));
            this.setDay(properties.getProperty("uptime_in_days"));
            this.setClientNum(properties.getProperty("connected_clients"));
            this.setPort(properties.getProperty("tcp_port"));
            String clusterEnabled = properties.getProperty("cluster_enabled");
            if (null != clusterEnabled) {
                this.setCluster(Integer.parseInt(clusterEnabled) > 0);
            }
            if (null != (aofEnabled = properties.getProperty("aof_enabled"))) {
                this.setAOF(Integer.parseInt(aofEnabled) != 0);
            }
        }
    }

    public String getVersion() {
        return this.version;
    }

    public String getPort() {
        return this.port;
    }

    public String getDay() {
        return this.day;
    }

    public String getClientNum() {
        return this.clientNum;
    }

    public String getTotalMem() {
        return this.totalMem;
    }

    public String getUsedMem() {
        return this.usedMem;
    }

    public Long getKeyNum() {
        return this.keyNum;
    }

    public boolean isCluster() {
        return this.isCluster;
    }

    public boolean isAOF() {
        return this.isAOF;
    }

    public List<RedisCmdStat> getRedisCmdStat() {
        return this.redisCmdStat;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setDay(String day) {
        this.day = day;
    }

    public void setClientNum(String clientNum) {
        this.clientNum = clientNum;
    }

    public void setTotalMem(String totalMem) {
        this.totalMem = totalMem;
    }

    public void setUsedMem(String usedMem) {
        this.usedMem = usedMem;
    }

    public void setKeyNum(Long keyNum) {
        this.keyNum = keyNum;
    }

    public void setCluster(boolean isCluster) {
        this.isCluster = isCluster;
    }

    public void setAOF(boolean isAOF) {
        this.isAOF = isAOF;
    }

    public void setRedisCmdStat(List<RedisCmdStat> redisCmdStat) {
        this.redisCmdStat = redisCmdStat;
    }
}

