/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie;

import cn.dreampie.AbstractLessCss;
import cn.dreampie.LessCompiler;
import cn.dreampie.LessCssException;
import cn.dreampie.LessException;
import cn.dreampie.LogKit;
import cn.dreampie.NodeJsLessCssCompiler;
import cn.dreampie.resource.LessSource;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Arrays;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.StringUtils;

public class LessCssCompiler
extends AbstractLessCss {
    private Log log = LogKit.getLog();
    private Object lessCompiler;
    protected File outputDirectory;
    private boolean compress;
    protected boolean watch = false;
    private int watchInterval = 1000;
    private String encoding;
    private boolean force;
    private File lessJs;
    private String nodeExecutable;
    private String outputFileFormat;
    private static final String FILE_NAME_FORMAT_PARAMETER_REGEX = "\\{fileName\\}";
    private long lastErrorModified = 0L;

    public void execute() throws LessCssException {
        this.log.info((CharSequence)("sourceDirectory = " + this.sourceDirectory));
        this.log.info((CharSequence)("outputDirectory = " + this.outputDirectory));
        this.log.debug((CharSequence)("includes = " + Arrays.toString(this.includes)));
        this.log.debug((CharSequence)("excludes = " + Arrays.toString(this.excludes)));
        this.log.debug((CharSequence)("force = " + this.force));
        this.log.debug((CharSequence)("lessJs = " + this.lessJs));
        this.log.debug((CharSequence)("skip = " + this.skip));
        if (!this.skip) {
            if (this.watch) {
                this.log.info((CharSequence)("Watching " + this.sourceDirectory));
                if (this.force) {
                    this.force = false;
                    this.log.info((CharSequence)"Disabled the 'force' flag in watch mode.");
                }
                Thread.currentThread().setPriority(1);
                while (this.watch && !Thread.currentThread().isInterrupted()) {
                    this.executeInternal();
                    try {
                        Thread.sleep(this.watchInterval);
                    }
                    catch (InterruptedException e) {
                        this.log.error((CharSequence)"interrupted");
                    }
                }
            } else {
                this.executeInternal();
            }
        } else {
            this.log.info((CharSequence)"Skipping plugin execution per configuration");
        }
    }

    private void executeInternal() throws LessCssException {
        Object[] files = this.getIncludedFiles();
        if (files == null || files.length < 1) {
            this.log.info((CharSequence)"Nothing to compile - no LESS sources found");
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug((CharSequence)("included files = " + Arrays.toString(files)));
            }
            Object lessCompiler = this.initLessCompiler();
            this.compileIfChanged((String[])files, lessCompiler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compileIfChanged(String[] files, Object lessCompiler) throws LessCssException {
        try {
            for (String file : files) {
                File input = new File(this.sourceDirectory, file);
                this.buildContext.removeMessages(input);
                if (this.outputFileFormat != null) {
                    file = this.outputFileFormat.replaceAll(FILE_NAME_FORMAT_PARAMETER_REGEX, file.replace(".less", ""));
                }
                String outFile = null;
                outFile = this.isCompress() ? file.replace(".less", ".min.css") : file.replace(".less", ".css");
                File output = new File(this.outputDirectory, outFile);
                if (!output.getParentFile().exists() && !output.getParentFile().mkdirs()) {
                    throw new LessCssException("Cannot create output directory " + output.getParentFile());
                }
                try {
                    LessSource lessSource = new LessSource(input);
                    long lessLastModified = lessSource.getLastModifiedIncludingImports();
                    if (!output.exists() || (this.force || output.lastModified() < lessLastModified) && this.lastErrorModified < lessLastModified) {
                        this.lastErrorModified = lessLastModified;
                        long compilationStarted = System.currentTimeMillis();
                        this.log.info((CharSequence)("Compiling LESS source: " + file));
                        if (lessCompiler instanceof LessCompiler) {
                            ((LessCompiler)lessCompiler).compile(lessSource, output, this.force);
                        } else {
                            ((NodeJsLessCssCompiler)lessCompiler).compile(lessSource, output, this.force);
                        }
                        this.buildContext.refresh(output);
                        this.log.info((CharSequence)("Finished compilation to " + this.outputDirectory + " in " + (System.currentTimeMillis() - compilationStarted) + " ms"));
                        continue;
                    }
                    if (this.watch) continue;
                    this.log.info((CharSequence)("Bypassing LESS source: " + file + " (not modified)"));
                }
                catch (IOException e) {
                    throw new LessCssException("Error while compiling LESS source: " + file, e);
                }
                catch (LessException e) {
                    String message = e.getMessage();
                    if (StringUtils.isEmpty((String)message)) {
                        message = "Error compiling LESS source";
                    }
                    throw new LessCssException("Error while compiling LESS source: " + file, e);
                }
                catch (InterruptedException e) {
                    throw new LessCssException("Error while compiling LESS source: " + file, e);
                }
            }
        }
        finally {
            if (lessCompiler instanceof NodeJsLessCssCompiler) {
                ((NodeJsLessCssCompiler)lessCompiler).close();
            }
        }
    }

    private Object initLessCompiler() throws LessCssException {
        if (this.lessCompiler == null) {
            if (this.nodeExecutable != null) {
                NodeJsLessCssCompiler nodeJsLessCssCompiler;
                try {
                    nodeJsLessCssCompiler = new NodeJsLessCssCompiler(this.nodeExecutable, this.compress, this.encoding, this.log);
                }
                catch (IOException e) {
                    throw new LessCssException(e.getMessage(), e);
                }
                if (this.lessJs != null) {
                    throw new LessCssException("Custom LESS JavaScript is not currently supported when using nodeExecutable");
                }
                this.lessCompiler = nodeJsLessCssCompiler;
            } else {
                LessCompiler newLessCompiler = new LessCompiler();
                newLessCompiler.setCompress(this.compress);
                newLessCompiler.setEncoding(this.encoding);
                if (this.lessJs != null) {
                    try {
                        newLessCompiler.setLessJs(this.lessJs.toURI().toURL());
                    }
                    catch (MalformedURLException e) {
                        throw new LessCssException("Error while loading LESS JavaScript: " + this.lessJs.getAbsolutePath(), e);
                    }
                }
                this.lessCompiler = newLessCompiler;
            }
        }
        return this.lessCompiler;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public boolean isCompress() {
        return this.compress;
    }

    public void setCompress(boolean compress) {
        this.compress = compress;
    }

    public boolean isWatch() {
        return this.watch;
    }

    public void setWatch(boolean watch) {
        this.watch = watch;
    }

    public int getWatchInterval() {
        return this.watchInterval;
    }

    public void setWatchInterval(int watchInterval) {
        this.watchInterval = watchInterval;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean isForce() {
        return this.force;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public File getLessJs() {
        return this.lessJs;
    }

    public void setLessJs(File lessJs) {
        this.lessJs = lessJs;
    }

    public String getNodeExecutable() {
        return this.nodeExecutable;
    }

    public void setNodeExecutable(String nodeExecutable) {
        this.nodeExecutable = nodeExecutable;
    }

    public String getOutputFileFormat() {
        return this.outputFileFormat;
    }

    public void setOutputFileFormat(String outputFileFormat) {
        this.outputFileFormat = outputFileFormat;
    }

    public long getLastErrorModified() {
        return this.lastErrorModified;
    }

    public void setLastErrorModified(long lastErrorModified) {
        this.lastErrorModified = lastErrorModified;
    }
}

