/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie;

import cn.dreampie.AbstractLessCssMojo;
import cn.dreampie.LessCssException;
import cn.dreampie.LogKit;
import cn.dreampie.resource.LessSource;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.codehaus.plexus.util.Scanner;

@Mojo(name="tree", threadSafe=true)
public class LessCssTreeMojo
extends AbstractLessCssMojo {
    private Log log = this.getLog();

    protected String[] getIncludedFiles() {
        Scanner scanner = this.buildContext.newScanner(this.sourceDirectory, true);
        scanner.setIncludes(this.includes);
        scanner.setExcludes(this.excludes);
        scanner.scan();
        return scanner.getIncludedFiles();
    }

    public void execute() {
        LogKit.setLog(this.log);
        this.log.info((CharSequence)("sourceDirectory = " + this.sourceDirectory));
        this.log.debug((CharSequence)("includes = " + Arrays.toString(this.includes)));
        this.log.debug((CharSequence)("excludes = " + Arrays.toString(this.excludes)));
        String[] files = this.getIncludedFiles();
        if (files == null || files.length < 1) {
            this.log.info((CharSequence)"No less sources found");
        } else {
            this.log.info((CharSequence)"The following less sources have been resolved:");
            for (String file : files) {
                File lessFile = new File(this.sourceDirectory, file);
                try {
                    LessSource lessSource = new LessSource(lessFile);
                    this.listLessSource(lessSource, file, 0, false);
                }
                catch (FileNotFoundException e) {
                    throw new LessCssException("Error while loading less source: " + lessFile.getAbsolutePath(), e);
                }
                catch (IOException e) {
                    throw new LessCssException("Error while loading less source: " + lessFile.getAbsolutePath(), e);
                }
            }
        }
    }

    private void listLessSource(LessSource lessSource, String path, int level, boolean last) {
        String prefix = "";
        if (level > 0) {
            for (int i = 1; i <= level; ++i) {
                prefix = i == level && last ? prefix + "`-- " : (i == level ? prefix + "|-- " : prefix + "|   ");
            }
        }
        this.log.info((CharSequence)(prefix + path));
        Iterator it = lessSource.getImports().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            this.listLessSource((LessSource)entry.getValue(), (String)entry.getKey(), level + 1, !it.hasNext());
        }
    }
}

