/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.json;

import cn.hutool.core.bean.OptionalBean;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.convert.ConvertException;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.core.getter.OptNullBasicTypeFromObjectGetter;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSON;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONConfig;
import cn.hutool.json.JSONConverter;
import cn.hutool.json.JSONNull;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import java.time.LocalDateTime;
import java.util.Date;

public interface JSONGetter<K>
extends OptNullBasicTypeFromObjectGetter<K> {
    public JSONConfig getConfig();

    default public boolean isNull(K key) {
        return JSONNull.NULL.equals(this.getObj(key));
    }

    default public String getStrEscaped(K key) {
        return this.getStrEscaped(key, null);
    }

    default public String getStrEscaped(K key, String defaultValue) {
        return JSONUtil.escape(this.getStr(key, defaultValue));
    }

    default public JSONArray getJSONArray(K key) {
        Object object = this.getObj(key);
        if (null == object) {
            return null;
        }
        if (object instanceof JSON) {
            return (JSONArray)object;
        }
        return new JSONArray(object, this.getConfig());
    }

    default public JSONObject getJSONObject(K key) {
        Object object = this.getObj(key);
        if (null == object) {
            return null;
        }
        if (object instanceof JSON) {
            return (JSONObject)object;
        }
        return new JSONObject(object, this.getConfig());
    }

    default public <T> T getBean(K key, Class<T> beanType) {
        JSONObject obj = this.getJSONObject(key);
        return null == obj ? null : (T)obj.toBean(beanType);
    }

    @Override
    default public Date getDate(K key, Date defaultValue) {
        Object obj = this.getObj(key);
        if (null == obj) {
            return defaultValue;
        }
        if (obj instanceof Date) {
            return (Date)obj;
        }
        String format = OptionalBean.ofNullable(this.getConfig()).getBean(JSONConfig::getDateFormat).get();
        if (StrUtil.isNotBlank(format)) {
            String str = Convert.toStr(obj);
            if (null == str) {
                return defaultValue;
            }
            return DateUtil.parse((CharSequence)str, format);
        }
        return Convert.toDate(obj, defaultValue);
    }

    default public LocalDateTime getLocalDateTime(K key, LocalDateTime defaultValue) {
        Object obj = this.getObj(key);
        if (null == obj) {
            return defaultValue;
        }
        if (obj instanceof LocalDateTime) {
            return (LocalDateTime)obj;
        }
        String format = OptionalBean.ofNullable(this.getConfig()).getBean(JSONConfig::getDateFormat).get();
        if (StrUtil.isNotBlank(format)) {
            String str = Convert.toStr(obj);
            if (null == str) {
                return defaultValue;
            }
            return LocalDateTimeUtil.parse((CharSequence)str, format);
        }
        return Convert.toLocalDateTime(obj, defaultValue);
    }

    default public <T> T get(K key, Class<T> type) throws ConvertException {
        return this.get(key, type, false);
    }

    default public <T> T get(K key, Class<T> type, boolean ignoreError) throws ConvertException {
        Object value = this.getObj(key);
        if (null == value) {
            return null;
        }
        return JSONConverter.jsonConvert(type, value, ignoreError);
    }
}

