/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.json;

import cn.hutool.core.convert.ConvertException;
import cn.hutool.core.getter.OptNullBasicTypeFromObjectGetter;
import cn.hutool.json.InternalJSONUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;

public abstract class JSONGetter<K>
extends OptNullBasicTypeFromObjectGetter<K> {
    public String getStr(K key, String defaultValue) {
        String str = super.getStr(key, defaultValue);
        if (null == str) {
            return defaultValue;
        }
        return JSONUtil.escape(str);
    }

    public JSONArray getJSONArray(K key) {
        Object object = this.getObj(key);
        if (null == object) {
            return null;
        }
        if (object instanceof JSONArray) {
            return (JSONArray)object;
        }
        return new JSONArray(object);
    }

    public JSONObject getJSONObject(K key) {
        Object object = this.getObj(key);
        if (null == object) {
            return null;
        }
        if (object instanceof JSONObject) {
            return (JSONObject)object;
        }
        return new JSONObject(object);
    }

    public <T> T getBean(K key, Class<T> beanType) {
        JSONObject obj = this.getJSONObject(key);
        return (T)(null == obj ? null : obj.toBean(beanType));
    }

    public <T> T get(K key, Class<T> type) throws ConvertException {
        return this.get(key, type, false);
    }

    public <T> T get(K key, Class<T> type, boolean ignoreError) throws ConvertException {
        Object value = this.getObj(key);
        if (null == value) {
            return null;
        }
        return (T)InternalJSONUtil.jsonConvert(type, value, ignoreError);
    }
}

