/*
 * Decompiled with CFR 0.152.
 */
package cn.xuyanwu.spring.file.storage.aspect;

import cn.xuyanwu.spring.file.storage.FileInfo;
import cn.xuyanwu.spring.file.storage.aspect.DownloadThAspectChainCallback;
import cn.xuyanwu.spring.file.storage.aspect.FileStorageAspect;
import cn.xuyanwu.spring.file.storage.platform.FileStorage;
import java.io.InputStream;
import java.util.Iterator;
import java.util.function.Consumer;

public class DownloadThAspectChain {
    private DownloadThAspectChainCallback callback;
    private Iterator<FileStorageAspect> aspectIterator;

    public DownloadThAspectChain(Iterable<FileStorageAspect> aspects, DownloadThAspectChainCallback callback) {
        this.aspectIterator = aspects.iterator();
        this.callback = callback;
    }

    public void next(FileInfo fileInfo, FileStorage fileStorage, Consumer<InputStream> consumer) {
        if (this.aspectIterator.hasNext()) {
            this.aspectIterator.next().downloadThAround(this, fileInfo, fileStorage, consumer);
        } else {
            this.callback.run(fileInfo, fileStorage, consumer);
        }
    }

    public DownloadThAspectChainCallback getCallback() {
        return this.callback;
    }

    public Iterator<FileStorageAspect> getAspectIterator() {
        return this.aspectIterator;
    }

    public void setCallback(DownloadThAspectChainCallback callback) {
        this.callback = callback;
    }

    public void setAspectIterator(Iterator<FileStorageAspect> aspectIterator) {
        this.aspectIterator = aspectIterator;
    }
}

