/*
 * Decompiled with CFR 0.152.
 */
package cn.xuyanwu.spring.file.storage.platform;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.StrUtil;
import cn.xuyanwu.spring.file.storage.FileInfo;
import cn.xuyanwu.spring.file.storage.UploadPretreatment;
import cn.xuyanwu.spring.file.storage.exception.FileStorageRuntimeException;
import cn.xuyanwu.spring.file.storage.platform.FileStorage;
import com.upyun.RestManager;
import com.upyun.UpException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.function.Consumer;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class UpyunUssFileStorage
implements FileStorage {
    private String platform;
    private String username;
    private String password;
    private String bucketName;
    private String domain;
    private String basePath;
    private RestManager client;

    public RestManager getClient() {
        if (this.client == null) {
            this.client = new RestManager(this.bucketName, this.username, this.password);
        }
        return this.client;
    }

    @Override
    public void close() {
        this.client = null;
    }

    @Override
    public boolean save(FileInfo fileInfo, UploadPretreatment pre) {
        String newFileKey = this.basePath + fileInfo.getPath() + fileInfo.getFilename();
        fileInfo.setBasePath(this.basePath);
        fileInfo.setUrl(this.domain + newFileKey);
        RestManager manager = this.getClient();
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put(RestManager.PARAMS.CONTENT_TYPE.getValue(), fileInfo.getContentType());
            try (Response result = manager.writeFile(newFileKey, pre.getFileWrapper().getInputStream(), params);){
                if (!result.isSuccessful()) {
                    throw new UpException(result.toString());
                }
            }
            byte[] thumbnailBytes = pre.getThumbnailBytes();
            if (thumbnailBytes != null) {
                String newThFileKey = this.basePath + fileInfo.getPath() + fileInfo.getThFilename();
                fileInfo.setThUrl(this.domain + newThFileKey);
                HashMap<String, String> thParams = new HashMap<String, String>();
                thParams.put(RestManager.PARAMS.CONTENT_TYPE.getValue(), fileInfo.getThContentType());
                Response thResult = manager.writeFile(newThFileKey, (InputStream)new ByteArrayInputStream(thumbnailBytes), thParams);
                if (!thResult.isSuccessful()) {
                    throw new UpException(thResult.toString());
                }
            }
            return true;
        }
        catch (UpException | IOException e) {
            try {
                manager.deleteFile(newFileKey, null).close();
            }
            catch (UpException | IOException throwable) {
                // empty catch block
            }
            throw new FileStorageRuntimeException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01platform\uff1a" + this.platform + "\uff0cfilename\uff1a" + fileInfo.getOriginalFilename(), e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean delete(FileInfo fileInfo) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean exists(FileInfo fileInfo) {
        try (Response response = this.getClient().getFileInfo(fileInfo.getBasePath() + fileInfo.getPath() + fileInfo.getFilename());){
            boolean bl = StrUtil.isNotBlank((CharSequence)response.header("x-upyun-file-size"));
            return bl;
        }
        catch (UpException | IOException e) {
            throw new FileStorageRuntimeException("\u5224\u65ad\u6587\u4ef6\u662f\u5426\u5b58\u5728\u5931\u8d25\uff01fileInfo\uff1a" + fileInfo, e);
        }
    }

    @Override
    public void download(FileInfo fileInfo, Consumer<InputStream> consumer) {
        try (Response response = this.getClient().readFile(fileInfo.getBasePath() + fileInfo.getPath() + fileInfo.getFilename());
             ResponseBody body = response.body();
             InputStream in = body == null ? null : body.byteStream();){
            if (body == null) {
                throw new FileStorageRuntimeException("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff0c\u7ed3\u679c\u4e3a null \uff01fileInfo\uff1a" + fileInfo);
            }
            if (!response.isSuccessful()) {
                throw new UpException(IoUtil.read((InputStream)in, (Charset)StandardCharsets.UTF_8));
            }
            consumer.accept(in);
        }
        catch (UpException | IOException e) {
            throw new FileStorageRuntimeException("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff01fileInfo\uff1a" + fileInfo, e);
        }
    }

    @Override
    public void downloadTh(FileInfo fileInfo, Consumer<InputStream> consumer) {
        if (StrUtil.isBlank((CharSequence)fileInfo.getThFilename())) {
            throw new FileStorageRuntimeException("\u7f29\u7565\u56fe\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff0c\u6587\u4ef6\u4e0d\u5b58\u5728\uff01fileInfo\uff1a" + fileInfo);
        }
        try (Response response = this.getClient().readFile(fileInfo.getBasePath() + fileInfo.getPath() + fileInfo.getThFilename());
             ResponseBody body = response.body();
             InputStream in = body == null ? null : body.byteStream();){
            if (body == null) {
                throw new FileStorageRuntimeException("\u7f29\u7565\u56fe\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff0c\u7ed3\u679c\u4e3a null \uff01fileInfo\uff1a" + fileInfo);
            }
            if (!response.isSuccessful()) {
                throw new UpException(IoUtil.read((InputStream)in, (Charset)StandardCharsets.UTF_8));
            }
            consumer.accept(in);
        }
        catch (UpException | IOException e) {
            throw new FileStorageRuntimeException("\u7f29\u7565\u56fe\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff01fileInfo\uff1a" + fileInfo, e);
        }
    }

    @Override
    public String getPlatform() {
        return this.platform;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getBasePath() {
        return this.basePath;
    }

    @Override
    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public void setClient(RestManager client) {
        this.client = client;
    }
}

