/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.ast.expr;

import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLDataTypeImpl;
import com.alibaba.druid.sql.ast.expr.SQLNumericLiteralExpr;
import com.alibaba.druid.sql.ast.expr.SQLValuableExpr;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.alibaba.druid.util.Utils;
import java.math.BigDecimal;

public class SQLNumberExpr
extends SQLNumericLiteralExpr
implements SQLValuableExpr {
    private static SQLDataType defaultDataType = new SQLDataTypeImpl("number");
    private Number number;
    private char[] chars;

    public SQLNumberExpr() {
    }

    public SQLNumberExpr(Number number) {
        this.number = number;
    }

    public SQLNumberExpr(char[] chars) {
        this.chars = chars;
    }

    @Override
    public Number getNumber() {
        if (this.chars != null && this.number == null) {
            this.number = new BigDecimal(this.chars);
        }
        return this.number;
    }

    @Override
    public Number getValue() {
        return this.getNumber();
    }

    @Override
    public void setNumber(Number number) {
        this.number = number;
        this.chars = null;
    }

    public void output(StringBuilder buf) {
        if (this.chars != null) {
            buf.append(this.chars);
        } else {
            buf.append(this.number.toString());
        }
    }

    @Override
    public void output(StringBuffer buf) {
        if (this.chars != null) {
            buf.append(this.chars);
        } else {
            buf.append(this.number.toString());
        }
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        visitor.visit(this);
        visitor.endVisit(this);
    }

    @Override
    public int hashCode() {
        Number number = this.getNumber();
        if (number == null) {
            return 0;
        }
        return number.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this.chars != null && this.number == null) {
            this.number = new BigDecimal(this.chars);
        }
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SQLNumberExpr other = (SQLNumberExpr)obj;
        return Utils.equals(this.getNumber(), other.getNumber());
    }

    @Override
    public SQLNumberExpr clone() {
        return new SQLNumberExpr(this.number);
    }

    @Override
    public SQLDataType computeDataType() {
        return defaultDataType;
    }
}

