/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.config.spring.util;

import com.alibaba.dubbo.config.annotation.Reference;
import com.alibaba.dubbo.config.annotation.Service;
import org.springframework.util.StringUtils;

public class AnnotationUtils {
    public static String resolveInterfaceName(Service service, Class<?> defaultInterfaceClass) throws IllegalStateException {
        String interfaceName;
        if (StringUtils.hasText((String)service.interfaceName())) {
            interfaceName = service.interfaceName();
        } else if (!Void.TYPE.equals(service.interfaceClass())) {
            interfaceName = service.interfaceClass().getName();
        } else if (defaultInterfaceClass.isInterface()) {
            interfaceName = defaultInterfaceClass.getName();
        } else {
            throw new IllegalStateException("The @Service undefined interfaceClass or interfaceName, and the type " + defaultInterfaceClass.getName() + " is not a interface.");
        }
        return interfaceName;
    }

    public static String resolveInterfaceName(Reference reference, Class<?> defaultInterfaceClass) throws IllegalStateException {
        String interfaceName;
        if (!"".equals(reference.interfaceName())) {
            interfaceName = reference.interfaceName();
        } else if (!Void.TYPE.equals(reference.interfaceClass())) {
            interfaceName = reference.interfaceClass().getName();
        } else if (defaultInterfaceClass.isInterface()) {
            interfaceName = defaultInterfaceClass.getName();
        } else {
            throw new IllegalStateException("The @Reference undefined interfaceClass or interfaceName, and the type " + defaultInterfaceClass.getName() + " is not a interface.");
        }
        return interfaceName;
    }
}

