/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.dbsync.binlog;

import com.taobao.tddl.dbsync.binlog.JsonConversion;
import com.taobao.tddl.dbsync.binlog.LogBuffer;
import java.util.ArrayList;

public class JsonDiffConversion {
    public static final int DIFF_OPERATION_REPLACE = 0;
    public static final int DIFF_OPERATION_INSERT = 1;
    public static final int DIFF_OPERATION_REMOVE = 2;
    public static final int JSON_DIFF_OPERATION_COUNT = 3;

    public static StringBuilder print_json_diff(LogBuffer buffer, long len, String columnName, int columnIndex, String charsetName) {
        long value_length;
        int position = buffer.position();
        ArrayList<String> operation_names = new ArrayList<String>();
        while (buffer.hasRemaining()) {
            int operation_int = buffer.getUint8();
            if (operation_int >= 3) {
                throw new IllegalArgumentException("reading operation type (invalid operation code)");
            }
            long path_length = buffer.getPackedLong();
            if (path_length > len) {
                throw new IllegalArgumentException("skipping path");
            }
            byte[] lastP = buffer.getData(buffer.position() + (int)path_length - 1, 1);
            String operation_name = JsonDiffConversion.json_diff_operation_name(operation_int, lastP[0]);
            operation_names.add(operation_name);
            buffer.forward((int)path_length);
            if (operation_int == 2) continue;
            value_length = buffer.getPackedLong();
            if (value_length > len) {
                throw new IllegalArgumentException("skipping path");
            }
            buffer.forward((int)value_length);
        }
        StringBuilder builder = new StringBuilder();
        for (int i = operation_names.size() - 1; i >= 0; --i) {
            if (i != 0 && operation_names.get(i - 1) == operation_names.get(i)) continue;
            builder.append((String)operation_names.get(i)).append("(");
        }
        if (columnName != null) {
            builder.append(columnName);
        } else {
            builder.append("@").append(columnIndex);
        }
        if (operation_names.size() == 0) {
            return builder;
        }
        builder.append(", ");
        buffer.position(position);
        int diff_i = 0;
        while (buffer.hasRemaining()) {
            int operation_int = buffer.getUint8();
            long path_length = buffer.getPackedLong();
            builder.append('\'').append(buffer.getFixString((int)path_length)).append('\'');
            if (operation_int != 2) {
                builder.append(", ");
                value_length = buffer.getPackedLong();
                JsonConversion.Json_Value jsonValue = JsonConversion.parse_value(buffer.getUint8(), buffer, value_length - 1L, charsetName);
                buffer.forward((int)value_length - 1);
                if (jsonValue.m_type == JsonConversion.Json_enum_type.ERROR) {
                    throw new IllegalArgumentException("parsing json value");
                }
                StringBuilder jsonBuilder = new StringBuilder();
                jsonValue.toJsonString(jsonBuilder, charsetName);
                builder.append((CharSequence)jsonBuilder);
            }
            if (!buffer.hasRemaining() || operation_names.get(diff_i + 1) != operation_names.get(diff_i)) {
                builder.append(")");
            }
            if (buffer.hasRemaining()) {
                builder.append(", ");
            }
            ++diff_i;
        }
        return builder;
    }

    private static String json_diff_operation_name(int operationType, int last_path_char) {
        switch (operationType) {
            case 0: {
                return "JSON_REPLACE";
            }
            case 1: {
                if (last_path_char == 93) {
                    return "JSON_ARRAY_INSERT";
                }
                return "JSON_INSERT";
            }
            case 2: {
                return "JSON_REMOVE";
            }
        }
        throw new IllegalArgumentException("illeagal operationType : " + operationType);
    }
}

