/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.clientlibrary.common;

import java.util.concurrent.atomic.AtomicReference;

public abstract class BackEndTask {
    private final AtomicReference<TaskStatus> status = new AtomicReference<TaskStatus>(TaskStatus.STOPPED);
    private volatile boolean hasTrigger = false;
    private final Object updateCond = new Object();
    private final Object stopCond = new Object();
    protected String taskName = "backend-task";

    public void start() {
        if (this.status.compareAndSet(TaskStatus.STOPPED, TaskStatus.RUNNING)) {
            Thread backEndThread = new Thread(this::runWrapper);
            backEndThread.setName(this.taskName);
            backEndThread.setDaemon(true);
            backEndThread.start();
        }
    }

    protected abstract void run();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runWrapper() {
        try {
            this.run();
        }
        finally {
            this.status.set(TaskStatus.STOPPED);
            Object object = this.stopCond;
            synchronized (object) {
                this.stopCond.notifyAll();
            }
        }
    }

    public boolean isRunning() {
        return TaskStatus.RUNNING.equals((Object)this.status.get());
    }

    public boolean isStopped() {
        return TaskStatus.STOPPED.equals((Object)this.status.get());
    }

    public void stop() {
        if (this.status.compareAndSet(TaskStatus.RUNNING, TaskStatus.STOPPING)) {
            this.triggerUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerUpdate() {
        Object object = this.updateCond;
        synchronized (object) {
            this.hasTrigger = true;
            this.updateCond.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitStopped(long timeout) {
        Object object = this.stopCond;
        synchronized (object) {
            if (!this.isStopped()) {
                try {
                    this.stopCond.wait(timeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return this.isStopped();
    }

    public void waitSignal(long timeout) {
        this.waitSignal(timeout, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitSignal(long timeout, long minInterval) {
        Object object = this.updateCond;
        synchronized (object) {
            if (this.isRunning() && !this.hasTrigger) {
                try {
                    this.updateCond.wait(timeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.hasTrigger = false;
            if (minInterval > 0L && this.isRunning()) {
                long interval;
                long waitTimestamp = System.currentTimeMillis();
                while (this.isRunning() && (interval = System.currentTimeMillis() - waitTimestamp) < minInterval) {
                    try {
                        this.updateCond.wait(minInterval - interval);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    private static enum TaskStatus {
        RUNNING,
        STOPPING,
        STOPPED;

    }
}

