/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.clientlibrary.common;

import com.aliyun.datahub.client.DatahubClient;
import com.aliyun.datahub.client.model.GetTopicResult;
import com.aliyun.datahub.clientlibrary.common.ClientProvider;
import com.aliyun.datahub.clientlibrary.common.Constants;
import com.aliyun.datahub.clientlibrary.common.DataClientImpl;
import com.aliyun.datahub.clientlibrary.common.IDataClient;
import com.aliyun.datahub.clientlibrary.common.Identifier;
import com.aliyun.datahub.clientlibrary.common.ShardManager;
import com.aliyun.datahub.clientlibrary.config.BaseConfig;
import com.aliyun.datahub.clientlibrary.exception.ExceptionRetryer;
import com.aliyun.datahub.clientlibrary.models.TopicInfo;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ClientHelper {
    private static final Map<Identifier, ShardManager> SHARD_MANAGER_MAP = new HashMap<Identifier, ShardManager>();
    protected String projectName;
    protected String topicName;
    protected String subId;
    protected String userAgent;
    protected IDataClient dataClient;
    protected ShardManager shardManager;
    protected TopicInfo topicInfo;
    private Identifier shardManagerIdentifier;
    private ClientProvider clientProvider;

    public ClientHelper(String projectName, String topicName, BaseConfig config) {
        this(projectName, topicName, null, config);
    }

    protected ClientHelper(String projectName, String topicName, String subId, BaseConfig config) {
        this.projectName = projectName;
        this.topicName = topicName;
        this.subId = subId;
        this.userAgent = this.genUserAgent(config.getUserAgent(), subId);
        this.clientProvider = config.getClientProvider();
        this.clientProvider.setUserAgent(this.userAgent);
        this.initTopic();
        this.shardManager = this.createShardManager(projectName, topicName, config);
        this.initDataClient(config);
    }

    protected void initDataClient(BaseConfig config) {
        this.dataClient = new DataClientImpl(this, this.projectName, this.topicName);
    }

    protected void initTopic() {
        this.topicInfo = new TopicInfo(this.getTopic(this.projectName, this.topicName));
    }

    public DatahubClient getClient() {
        return this.clientProvider.getClient();
    }

    public ShardManager getShardManager() {
        return this.shardManager;
    }

    public TopicInfo getTopicInfo() {
        return this.topicInfo;
    }

    public IDataClient getDataClient() {
        return this.dataClient;
    }

    public void close() {
        this.releaseShardManager();
    }

    private String genUserAgent(String part, String subId) {
        String userAgent = Constants.CLIENT_USER_AGENT;
        if (!StringUtils.isEmpty((CharSequence)subId)) {
            userAgent = userAgent + "-" + subId;
        }
        if (!StringUtils.isEmpty((CharSequence)part)) {
            userAgent = userAgent + "-" + part;
        }
        return userAgent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ShardManager createShardManager(String projectName, String topicName, BaseConfig config) {
        ShardManager manager;
        this.shardManagerIdentifier = new Identifier(projectName, topicName, config.getIdentifier());
        Map<Identifier, ShardManager> map = SHARD_MANAGER_MAP;
        synchronized (map) {
            manager = SHARD_MANAGER_MAP.get(this.shardManagerIdentifier);
            if (manager == null) {
                manager = new ShardManager(projectName, topicName, this.getClient());
                SHARD_MANAGER_MAP.put(this.shardManagerIdentifier, manager);
            }
            manager.incRef();
        }
        manager.init();
        return manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseShardManager() {
        if (this.shardManager != null && this.shardManagerIdentifier != null) {
            Map<Identifier, ShardManager> map = SHARD_MANAGER_MAP;
            synchronized (map) {
                if (this.shardManager.decRef() <= 0) {
                    SHARD_MANAGER_MAP.remove(this.shardManagerIdentifier);
                    this.shardManager.close();
                }
                this.shardManagerIdentifier = null;
            }
        }
    }

    private GetTopicResult getTopic(final String projectName, final String topicName) {
        return (GetTopicResult)new ExceptionRetryer<GetTopicResult>(){

            @Override
            protected GetTopicResult func() {
                return ClientHelper.this.getClient().getTopic(projectName, topicName);
            }
        }.run(3, 1000L);
    }
}

