/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.clientlibrary.common;

import com.aliyun.datahub.client.exception.AuthorizationFailureException;
import com.aliyun.datahub.client.exception.DatahubClientException;
import com.aliyun.datahub.client.exception.ExpiredAccessTokenException;
import com.aliyun.datahub.client.exception.InvalidParameterException;
import com.aliyun.datahub.client.exception.MalformedRecordException;
import com.aliyun.datahub.client.exception.NoPermissionException;
import com.aliyun.datahub.client.exception.SeekOutOfRangeException;
import com.aliyun.datahub.client.exception.ShardNotFoundException;
import com.aliyun.datahub.client.exception.ShardSealedException;
import com.aliyun.datahub.client.exception.SubscriptionOfflineException;
import com.aliyun.datahub.client.exception.SubscriptionOffsetResetException;
import com.aliyun.datahub.client.exception.SubscriptionSessionInvalidException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public class Constants {
    public static final long DEFAULT_LAST_SEQUENCE = -1L;
    public static final long DEFAULT_PLAN_VERSION = -1L;
    public static final int MAX_FETCH_SIZE = 1000;
    public static final int MAX_SHARD_READER_POOL_SIZE = 1024;
    public static final int RETRY_TIMES = 3;
    public static final int FETCH_RETRY_TIMES = 30;
    public static final long RETRY_INTERVAL_MS = 1000L;
    public static final long FETCH_LATEST_DELAY_MS = 500L;
    public static final float HEARTBEAT_INTERVAL_SCALE = 0.66f;
    public static final long UPDATE_SHARD_META_INTERVAL_MS = 600000L;
    public static final int PRODUCER_HEARTBEAT_INTERVAL_MS = 30000;
    public static final long TIME_AHEAD_TOKEN_EXPIRED = 300000L;
    public static final long LOG_INTERVAL_MS = 60000L;
    public static final long NOT_ACK_WARNING_TIMEOUT_MS = 60000L;
    public static final long MIN_FAST_RERTY_INTERVAL_MS = 1000L;
    public static final long CLOSE_TIMEOUT_MS = 2000L;
    public static final String PROJECT_NAME_KEY = "project";
    public static final String TOPIC_NAME_KEY = "topic";
    public static final String HTTP2_PROTOCOL_NAME = "http2";
    public static final String DATAHUB_ATTR_HOST = "__dh_host__";
    public static Set<Class<? extends DatahubClientException>> FATAL_EXCEPTIONS;
    public static Set<Class<? extends DatahubClientException>> CAN_NOT_RETRY_EXCEPTIONS;
    public static final String IP;
    public static final String VERSION;
    public static final String CLIENT_USER_AGENT;

    static {
        Enumeration<NetworkInterface> interfaces;
        FATAL_EXCEPTIONS = new HashSet<Class<? extends DatahubClientException>>();
        CAN_NOT_RETRY_EXCEPTIONS = new HashSet<Class<? extends DatahubClientException>>();
        FATAL_EXCEPTIONS.add(NoPermissionException.class);
        FATAL_EXCEPTIONS.add(AuthorizationFailureException.class);
        FATAL_EXCEPTIONS.add(MalformedRecordException.class);
        FATAL_EXCEPTIONS.add(InvalidParameterException.class);
        FATAL_EXCEPTIONS.add(SubscriptionOffsetResetException.class);
        FATAL_EXCEPTIONS.add(SubscriptionOfflineException.class);
        FATAL_EXCEPTIONS.add(SubscriptionSessionInvalidException.class);
        FATAL_EXCEPTIONS.add(SeekOutOfRangeException.class);
        CAN_NOT_RETRY_EXCEPTIONS.add(ShardSealedException.class);
        CAN_NOT_RETRY_EXCEPTIONS.add(ExpiredAccessTokenException.class);
        CAN_NOT_RETRY_EXCEPTIONS.add(ShardNotFoundException.class);
        String ip = null;
        try {
            interfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            throw new RuntimeException(e);
        }
        while (interfaces.hasMoreElements()) {
            NetworkInterface element = interfaces.nextElement();
            Enumeration<InetAddress> addresses = element.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress address = addresses.nextElement();
                if (address.isLoopbackAddress() || !(address instanceof Inet4Address)) continue;
                ip = address.getHostAddress();
            }
        }
        IP = ip;
        String path = "META-INF/maven/com.aliyun.datahub/datahub-client-library/pom.properties";
        Properties p = new Properties();
        try {
            p.load(Constants.class.getClassLoader().getResourceAsStream(path));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        VERSION = p.getProperty("version", "Unknown");
        CLIENT_USER_AGENT = "dcl-" + VERSION;
    }
}

