/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.clientlibrary.common;

import com.aliyun.datahub.client.DatahubClient;
import com.aliyun.datahub.client.exception.DatahubClientException;
import com.aliyun.datahub.clientlibrary.common.BackEndTask;
import com.aliyun.datahub.clientlibrary.models.ShardMeta;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShardManager
extends BackEndTask {
    private static final Logger LOG = LoggerFactory.getLogger(ShardManager.class);
    private String projectName;
    private String topicName;
    private DatahubClient client;
    private volatile ShardMeta shardMeta;
    private final Object finishCond = new Object();
    private AtomicInteger reference = new AtomicInteger(0);
    private volatile boolean inited = false;
    private volatile long fastRetryIntervalMs = 1000L;
    private volatile long lastRequestTime = -1L;

    public ShardManager(String projectName, String topicName, DatahubClient client) {
        this.taskName = "shard-manager";
        this.projectName = projectName;
        this.topicName = topicName;
        this.client = client;
        LOG.info("Shard manager created, {}/{}", (Object)projectName, (Object)topicName);
    }

    public synchronized void init() {
        if (!this.inited) {
            this.shardMeta = new ShardMeta(this.client.listShard(this.projectName, this.topicName));
            this.start();
            this.inited = true;
            LOG.info("Shard manager inited, {}/{}", (Object)this.projectName, (Object)this.topicName);
            LOG.debug("Update shard meta, Project: {}, Topic: {}, Shards: {}, Protocol: {}, ReferenceInterval: {}", new Object[]{this.projectName, this.topicName, this.shardMeta.getActiveShardIds().toString(), this.shardMeta.getProtocol(), this.shardMeta.getIntervalMs()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerUpdateAndWait() {
        this.triggerUpdate();
        Object object = this.finishCond;
        synchronized (object) {
            if (this.isRunning()) {
                try {
                    this.finishCond.wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public ShardMeta getShardMeta() {
        return this.shardMeta;
    }

    public void incRef() {
        this.reference.incrementAndGet();
    }

    public int decRef() {
        return this.reference.decrementAndGet();
    }

    public void close() {
        this.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void triggerFinish() {
        Object object = this.finishCond;
        synchronized (object) {
            this.finishCond.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - bad return control flow
     */
    private boolean updateShardMeta() {
        boolean bl;
        try {
            this.shardMeta = new ShardMeta(this.client.listShard(this.projectName, this.topicName));
            LOG.info("Update shard meta, Project: {}, Topic: {}, Shards: {}, Protocol: {}, ReferenceInterval: {}", new Object[]{this.projectName, this.topicName, this.shardMeta.getActiveShardIds().toString(), this.shardMeta.getProtocol(), this.shardMeta.getIntervalMs()});
            bl = this.shardMeta.isFinished();
        }
        catch (DatahubClientException e) {
            LOG.warn("Update shard meta failed, Project: {}, Topic: {}, Exception: {}", new Object[]{this.projectName, this.topicName, e.getMessage()});
            long now = System.currentTimeMillis();
            this.fastRetryIntervalMs = now - this.lastRequestTime > this.shardMeta.getIntervalMs() - 1L ? 1000L : Math.min(this.fastRetryIntervalMs + 1000L, 600000L);
            this.lastRequestTime = now;
        }
        catch (Throwable e2) {
            LOG.error("Update shard meta failed, Project: {}, Topic: {}", new Object[]{this.projectName, this.topicName, e2});
            {
                catch (Throwable throwable) {
                    long now = System.currentTimeMillis();
                    this.fastRetryIntervalMs = now - this.lastRequestTime > this.shardMeta.getIntervalMs() - 1L ? 1000L : Math.min(this.fastRetryIntervalMs + 1000L, 600000L);
                    this.lastRequestTime = now;
                    throw throwable;
                }
            }
            long now = System.currentTimeMillis();
            this.fastRetryIntervalMs = now - this.lastRequestTime > this.shardMeta.getIntervalMs() - 1L ? 1000L : Math.min(this.fastRetryIntervalMs + 1000L, 600000L);
            this.lastRequestTime = now;
        }
        long now = System.currentTimeMillis();
        this.fastRetryIntervalMs = now - this.lastRequestTime > this.shardMeta.getIntervalMs() - 1L ? 1000L : Math.min(this.fastRetryIntervalMs + 1000L, 600000L);
        this.lastRequestTime = now;
        return bl;
        return false;
    }

    @Override
    protected void run() {
        this.waitSignal(this.shardMeta.getIntervalMs(), this.fastRetryIntervalMs);
        while (this.isRunning()) {
            boolean finished = false;
            try {
                finished = this.updateShardMeta();
            }
            catch (Throwable e) {
                LOG.error("Update shard meta failed, Project: {}, Topic: {}", new Object[]{this.projectName, this.topicName, e});
            }
            if (finished) {
                this.triggerFinish();
                this.waitSignal(this.shardMeta.getIntervalMs(), this.fastRetryIntervalMs);
                continue;
            }
            this.waitSignal(this.fastRetryIntervalMs, this.fastRetryIntervalMs);
        }
        LOG.info("Shard manager closed, {}/{}", (Object)this.projectName, (Object)this.topicName);
    }
}

