/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.clientlibrary.config;

import com.aliyun.datahub.client.auth.Account;
import com.aliyun.datahub.client.auth.AliyunAccount;
import com.aliyun.datahub.client.common.DatahubConfig;
import com.aliyun.datahub.client.http.HttpConfig;
import com.aliyun.datahub.clientlibrary.common.ClientProvider;
import com.aliyun.datahub.clientlibrary.common.ClientProviderImpl;
import com.aliyun.datahub.clientlibrary.common.HelperBuilder;
import java.util.Objects;

public abstract class BaseConfig {
    protected String userAgent;
    protected DatahubConfig datahubConfig;
    protected HttpConfig httpConfig = new HttpConfig();
    protected int codecConcurrentNum = Runtime.getRuntime().availableProcessors() - 1;
    protected boolean enableP2P = false;
    protected ClientProvider clientProvider;
    private ConfigIdentifier identifier;

    public BaseConfig(String endpoint, String accessId, String accessKey) {
        this(endpoint, accessId, accessKey, null);
    }

    public BaseConfig(String endpoint, String accessId, String accessKey, String securityToken) {
        this.datahubConfig = new DatahubConfig(endpoint, (Account)new AliyunAccount(accessId, accessKey, securityToken), true);
        this.identifier = new ConfigIdentifier(endpoint, accessId, accessKey, securityToken);
    }

    public DatahubConfig getDatahubConfig() {
        return this.datahubConfig;
    }

    public HttpConfig getHttpConfig() {
        return this.httpConfig;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public boolean isEnableP2P() {
        return this.enableP2P;
    }

    public int getCodecConcurrentNum() {
        return this.codecConcurrentNum;
    }

    public ConfigIdentifier getIdentifier() {
        return this.identifier;
    }

    public HelperBuilder getHelperBuilder() {
        return new HelperBuilder(this);
    }

    public ClientProvider getClientProvider() {
        return this.clientProvider == null ? new ClientProviderImpl(this) : this.clientProvider;
    }

    public class ConfigIdentifier {
        private String endpoint;
        private String accessId;
        private String accessKey;
        private String securityToken;

        public ConfigIdentifier(String endpoint, String accessId, String accessKey, String securityToken) {
            this.endpoint = endpoint;
            this.accessId = accessId;
            this.accessKey = accessKey;
            this.securityToken = securityToken;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConfigIdentifier that = (ConfigIdentifier)o;
            return Objects.equals(this.endpoint, that.endpoint) && Objects.equals(this.accessId, that.accessId) && Objects.equals(this.accessKey, that.accessKey) && Objects.equals(this.securityToken, that.securityToken);
        }

        public int hashCode() {
            return Objects.hash(this.endpoint, this.accessId, this.accessKey, this.securityToken);
        }
    }
}

