/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.clientlibrary.config;

import com.aliyun.datahub.clientlibrary.callback.ShardReadEndCallback;
import com.aliyun.datahub.clientlibrary.common.ClientProvider;
import com.aliyun.datahub.clientlibrary.config.BaseConfig;
import com.aliyun.datahub.clientlibrary.config.CheckTaskConfig;
import com.aliyun.datahub.clientlibrary.interceptor.ReadInterceptorBuilder;

public class ConsumerConfig
extends BaseConfig {
    private static final long MIN_OFFSET_COMMIT_TIMEOUT_MS = 5000L;
    private static final long MAX_OFFSET_COMMIT_TIMEOUT_MS = 300000L;
    private static final long DEFAULT_OFFSET_COMMIT_TIMEOUT_MS = 30000L;
    private static final long MIN_CONSUMER_SESSION_TIMEOUT_MS = 60000L;
    private static final long MAX_CONSUMER_SESSION_TIMEOUT_MS = 180000L;
    private static final int DEFAULT_FETCH_SIZE = 500;
    private boolean autoCommit = true;
    private int fetchSize = 500;
    private long offsetCommitTimeoutMs = 30000L;
    private long sessionTimeoutMs = 60000L;
    private CheckTaskConfig checkTaskConfig = new CheckTaskConfig();
    private ShardReadEndCallback shardReadEndCallback = null;
    protected ReadInterceptorBuilder interceptorBuilder = new ReadInterceptorBuilder(this);

    public ConsumerConfig(String endpoint, String accessId, String accessKey) {
        super(endpoint, accessId, accessKey);
    }

    public ConsumerConfig(String endpoint, String accessId, String accessKey, String securityToken) {
        super(endpoint, accessId, accessKey, securityToken);
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    public ConsumerConfig setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
        return this;
    }

    public long getOffsetCommitTimeoutMs() {
        return this.offsetCommitTimeoutMs;
    }

    public ConsumerConfig setOffsetCommitTimeoutMs(long offsetCommitTimeoutMs) {
        this.offsetCommitTimeoutMs = offsetCommitTimeoutMs < 5000L ? 5000L : (offsetCommitTimeoutMs > 300000L ? 300000L : offsetCommitTimeoutMs);
        return this;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public ConsumerConfig setFetchSize(int fetchSize) {
        this.fetchSize = Math.min(fetchSize, 1000);
        return this;
    }

    public long getSessionTimeoutMs() {
        return this.sessionTimeoutMs;
    }

    public ConsumerConfig setSessionTimeoutMs(long sessionTimeoutMs) {
        this.sessionTimeoutMs = sessionTimeoutMs < 60000L ? 60000L : (sessionTimeoutMs > 180000L ? 180000L : sessionTimeoutMs);
        return this;
    }

    public ConsumerConfig setEnableBinary(boolean enableBinary) {
        this.datahubConfig.setEnableBinary(enableBinary);
        return this;
    }

    public ReadInterceptorBuilder getInterceptorBuilder() {
        return this.interceptorBuilder;
    }

    public ConsumerConfig setUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public ConsumerConfig setCodecConcurrentNum(int codecConcurrentNum) {
        this.codecConcurrentNum = codecConcurrentNum;
        return this;
    }

    public CheckTaskConfig getCheckTaskConfig() {
        return this.checkTaskConfig;
    }

    public ConsumerConfig setClientProvider(ClientProvider clientProvider) {
        this.clientProvider = clientProvider;
        return this;
    }

    public ShardReadEndCallback getShardReadEndCallback() {
        return this.shardReadEndCallback;
    }

    public ConsumerConfig setShardReadEndCallback(ShardReadEndCallback shardReadEndCallback) {
        this.shardReadEndCallback = shardReadEndCallback;
        return this;
    }
}

