/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.clientlibrary.consumer;

import com.aliyun.datahub.client.DatahubClient;
import com.aliyun.datahub.client.exception.DatahubClientException;
import com.aliyun.datahub.client.model.HeartbeatResult;
import com.aliyun.datahub.clientlibrary.common.BackEndTask;
import com.aliyun.datahub.clientlibrary.exception.ExceptionRetryer;
import com.aliyun.datahub.clientlibrary.models.Assignment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Heartbeat {
    private static final Logger LOG = LoggerFactory.getLogger(Heartbeat.class);
    private String projectName;
    private String topicName;
    private String subId;
    private DatahubClient client;
    private volatile HeartbeatTask heartbeatTask;

    Heartbeat(DatahubClient client, String projectName, String topicName, String subId) {
        this.client = client;
        this.projectName = projectName;
        this.topicName = topicName;
        this.subId = subId;
    }

    synchronized void start(String consumerId, long versionId, long heartbeatIntervalMs) {
        if (this.heartbeatTask != null) {
            this.heartbeatTask.stop();
        }
        this.heartbeatTask = new HeartbeatTask(consumerId, versionId, heartbeatIntervalMs);
        this.heartbeatTask.start();
    }

    synchronized void stop() {
        if (this.heartbeatTask == null) {
            return;
        }
        this.heartbeatTask.stop();
        this.heartbeatTask = null;
    }

    Assignment getAssignment() {
        return this.heartbeatTask != null ? this.heartbeatTask.getAssignment() : Assignment.EMPTY_ASSIGNMENT;
    }

    long getPlanVersion() {
        return this.heartbeatTask != null ? this.heartbeatTask.getPlanVersion() : -1L;
    }

    boolean checkRunning() {
        return this.heartbeatTask != null && this.heartbeatTask.checkRunning();
    }

    boolean updateReadEndShardList(List<String> readEndShardList) {
        return this.heartbeatTask != null && this.heartbeatTask.updateReadEndShardList(readEndShardList);
    }

    private class HeartbeatTask
    extends BackEndTask {
        private String consumerId;
        private long versionId;
        private long heartbeatIntervalMs;
        private long lastLogTime = -1L;
        private final Set<String> readEndShards = new HashSet<String>();
        private volatile Set<String> shards = new HashSet<String>();
        private volatile long planVersion = -1L;
        private volatile DatahubClientException exception = null;
        private volatile Assignment assignment = Assignment.EMPTY_ASSIGNMENT;

        HeartbeatTask(String consumerId, long versionId, long heartbeatIntervalMs) {
            this.taskName = "heartbeat";
            this.consumerId = consumerId;
            this.versionId = versionId;
            this.heartbeatIntervalMs = heartbeatIntervalMs;
        }

        Assignment getAssignment() {
            return this.assignment;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean updateReadEndShardList(List<String> readEndShardList) {
            if (!this.checkRunning() || readEndShardList.isEmpty()) {
                return false;
            }
            Set<String> set = this.readEndShards;
            synchronized (set) {
                int size = this.readEndShards.size();
                this.readEndShards.addAll(readEndShardList);
                return size < this.readEndShards.size();
            }
        }

        long getPlanVersion() {
            return this.planVersion;
        }

        boolean checkRunning() {
            if (this.exception != null) {
                throw this.exception;
            }
            return !this.isStopped();
        }

        @Override
        protected void run() {
            LOG.info("Consumer heartbeat start, Project: {}, Topic: {}, SubId: {}, ConsumerId: {}, IntervalMs: {}", new Object[]{Heartbeat.this.projectName, Heartbeat.this.topicName, Heartbeat.this.subId, this.consumerId, this.heartbeatIntervalMs});
            while (this.isRunning()) {
                boolean success;
                block9: {
                    success = false;
                    try {
                        this.heartbeat();
                        success = true;
                        long waitTimeMs = this.heartbeatIntervalMs / (long)(this.versionId <= 0L ? 3 : 1);
                        this.waitSignal(Math.max(waitTimeMs, 1000L));
                    }
                    catch (DatahubClientException e) {
                        if (this.isRunning()) {
                            if (ExceptionRetryer.isFatalException(e)) {
                                LOG.error("Heartbeat failed, Project: {}, Topic: {}, SubId: {}, ConsumerId: {}", new Object[]{Heartbeat.this.projectName, Heartbeat.this.topicName, Heartbeat.this.subId, this.consumerId, e});
                                this.exception = e;
                            } else if (ExceptionRetryer.canSwallow(e)) {
                                success = true;
                                LOG.info("Heartbeat failed, will retry, Project: {}, Topic: {}, SubId: {}, ConsumerId: {}", new Object[]{Heartbeat.this.projectName, Heartbeat.this.topicName, Heartbeat.this.subId, this.consumerId, e});
                            } else {
                                LOG.info("Heartbeat failed, try rejoin, Project: {}, Topic: {}, SubId: {}, ConsumerId: {}", new Object[]{Heartbeat.this.projectName, Heartbeat.this.topicName, Heartbeat.this.subId, this.consumerId, e});
                            }
                        }
                    }
                    catch (Throwable e) {
                        if (!this.isRunning()) break block9;
                        LOG.warn("Heartbeat failed, try rejoin, Project: {}, Topic: {}, SubId: {}, ConsumerId: {}", new Object[]{Heartbeat.this.projectName, Heartbeat.this.topicName, Heartbeat.this.subId, this.consumerId, e});
                    }
                }
                if (success) continue;
                this.assignment = Assignment.EMPTY_ASSIGNMENT;
                this.stop();
                break;
            }
            LOG.info("Consumer heartbeat stop, Project: {}, Topic: {}, SubId: {}, ConsumerId: {}", new Object[]{Heartbeat.this.projectName, Heartbeat.this.topicName, Heartbeat.this.subId, this.consumerId});
        }

        void heartbeat() {
            new ExceptionRetryer<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected Void func() {
                    ArrayList currentShardList = new ArrayList(HeartbeatTask.this.shards);
                    List readEndShardList = Collections.emptyList();
                    if (!HeartbeatTask.this.readEndShards.isEmpty()) {
                        LOG.info("Upload read end shards, Project: {}, Topic: {}, SubId: {}, ConsumerId: {}, ReadEndShardList: {}", new Object[]{Heartbeat.this.projectName, Heartbeat.this.topicName, Heartbeat.this.subId, HeartbeatTask.this.consumerId, HeartbeatTask.this.readEndShards.toString()});
                        Set set = HeartbeatTask.this.readEndShards;
                        synchronized (set) {
                            readEndShardList = new ArrayList(HeartbeatTask.this.readEndShards);
                        }
                    }
                    HeartbeatResult heartbeatResult = Heartbeat.this.client.heartbeat(Heartbeat.this.projectName, Heartbeat.this.topicName, Heartbeat.this.subId, HeartbeatTask.this.consumerId, HeartbeatTask.this.versionId, currentShardList, readEndShardList);
                    HeartbeatTask.this.planVersion = heartbeatResult.getPlanVersion();
                    HashSet newShards = new HashSet(heartbeatResult.getShardList());
                    if (newShards.equals(HeartbeatTask.this.shards)) {
                        if (HeartbeatTask.this.shards.isEmpty()) {
                            LOG.info("Waiting for assignment, Project: {}, Topic: {}, SubId: {}, ConsumerId: {}, Version: {}", new Object[]{Heartbeat.this.projectName, Heartbeat.this.topicName, Heartbeat.this.subId, HeartbeatTask.this.consumerId, HeartbeatTask.this.planVersion});
                        } else {
                            long now = System.currentTimeMillis();
                            if (now - HeartbeatTask.this.lastLogTime > 60000L) {
                                LOG.info("Consumer heartbeat, Project: {}, Topic: {}, SubId: {}, ConsumerId: {}, Version: {}", new Object[]{Heartbeat.this.projectName, Heartbeat.this.topicName, Heartbeat.this.subId, HeartbeatTask.this.consumerId, HeartbeatTask.this.planVersion});
                                HeartbeatTask.this.lastLogTime = now;
                            }
                        }
                        return null;
                    }
                    LOG.info("Consumer heartbeat success, Project: {}, Topic: {}, SubId: {}, ConsumerId: {}, Version: {}, OldShardList: {}, NewShardList: {}", new Object[]{Heartbeat.this.projectName, Heartbeat.this.topicName, Heartbeat.this.subId, HeartbeatTask.this.consumerId, HeartbeatTask.this.planVersion, HeartbeatTask.this.shards.toString(), ((Object)newShards).toString()});
                    HeartbeatTask.this.shards = newShards;
                    HeartbeatTask.this.assignment = new Assignment(HeartbeatTask.this.shards, System.currentTimeMillis());
                    HeartbeatTask.this.cleanReadEndShards();
                    return null;
                }

                @Override
                protected boolean isTerminated() {
                    return !HeartbeatTask.this.isRunning();
                }
            }.run(3, 1000L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cleanReadEndShards() {
            Set<String> set = this.readEndShards;
            synchronized (set) {
                this.readEndShards.retainAll(this.shards);
            }
        }
    }
}

